/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/cmndata.h>



PyDoc_STRVAR(doc_wxPrintPageRange_IsValid, "IsValid() -> bool\n"
"\n"
"Return true if both components are initialized correctly.");

extern "C" {static PyObject *meth_wxPrintPageRange_IsValid(PyObject *, PyObject *);}
static PyObject *meth_wxPrintPageRange_IsValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPrintPageRange *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintPageRange, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PrintPageRange, sipName_IsValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintPageRange_GetNumberOfPages, "GetNumberOfPages() -> int\n"
"\n"
"Return the number of pages in this range if it is valid.");

extern "C" {static PyObject *meth_wxPrintPageRange_GetNumberOfPages(PyObject *, PyObject *);}
static PyObject *meth_wxPrintPageRange_GetNumberOfPages(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPrintPageRange *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintPageRange, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNumberOfPages();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PrintPageRange, sipName_GetNumberOfPages, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPrintPageRange(void *, int);}
static void release_wxPrintPageRange(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxPrintPageRange *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxPrintPageRange(Py_ssize_t);}
static void *array_wxPrintPageRange(Py_ssize_t sipNrElem)
{
    return new ::wxPrintPageRange[sipNrElem];
}


extern "C" {static void array_delete_wxPrintPageRange(void *);}
static void array_delete_wxPrintPageRange(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxPrintPageRange *>(sipCpp);
}


extern "C" {static void assign_wxPrintPageRange(void *, Py_ssize_t, void *);}
static void assign_wxPrintPageRange(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxPrintPageRange *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxPrintPageRange *>(sipSrc);
}


extern "C" {static void *copy_wxPrintPageRange(const void *, Py_ssize_t);}
static void *copy_wxPrintPageRange(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxPrintPageRange(reinterpret_cast<const ::wxPrintPageRange *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPrintPageRange(sipSimpleWrapper *);}
static void dealloc_wxPrintPageRange(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPrintPageRange(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPrintPageRange(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPrintPageRange(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxPrintPageRange *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxPrintPageRange();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        int from;
        int to;

        static const char *sipKwdList[] = {
            sipName_from,
            sipName_to,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii", &from, &to))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxPrintPageRange(from, to);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxPrintPageRange* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxPrintPageRange, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxPrintPageRange(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxPrintPageRange[] = {
    {sipName_GetNumberOfPages, meth_wxPrintPageRange_GetNumberOfPages, METH_VARARGS, doc_wxPrintPageRange_GetNumberOfPages},
    {sipName_IsValid, meth_wxPrintPageRange_IsValid, METH_VARARGS, doc_wxPrintPageRange_IsValid}
};


extern "C" {static PyObject *varget_wxPrintPageRange_fromPage(void *, PyObject *, PyObject *);}
static PyObject *varget_wxPrintPageRange_fromPage(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
    ::wxPrintPageRange *sipCpp = reinterpret_cast< ::wxPrintPageRange *>(sipSelf);

    sipVal = sipCpp->fromPage;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxPrintPageRange_fromPage(void *, PyObject *, PyObject *);}
static int varset_wxPrintPageRange_fromPage(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::wxPrintPageRange *sipCpp = reinterpret_cast< ::wxPrintPageRange *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->fromPage = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxPrintPageRange_toPage(void *, PyObject *, PyObject *);}
static PyObject *varget_wxPrintPageRange_toPage(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
    ::wxPrintPageRange *sipCpp = reinterpret_cast< ::wxPrintPageRange *>(sipSelf);

    sipVal = sipCpp->toPage;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxPrintPageRange_toPage(void *, PyObject *, PyObject *);}
static int varset_wxPrintPageRange_toPage(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::wxPrintPageRange *sipCpp = reinterpret_cast< ::wxPrintPageRange *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->toPage = sipVal;

    return 0;
}

sipVariableDef variables_wxPrintPageRange[] = {
    {PropertyVariable, sipName_NumberOfPages, &methods_wxPrintPageRange[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_fromPage, (PyMethodDef *)varget_wxPrintPageRange_fromPage, (PyMethodDef *)varset_wxPrintPageRange_fromPage, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_toPage, (PyMethodDef *)varget_wxPrintPageRange_toPage, (PyMethodDef *)varset_wxPrintPageRange_toPage, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxPrintPageRange, "PrintPageRange() -> None\n"
"PrintPageRange(_from, to) -> None\n"
"\n"
"This class represents a range of pages to be printed.");


sipClassTypeDef sipTypeDef__core_wxPrintPageRange = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxPrintPageRange,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_PrintPageRange,
        {0, 0, 1},
        2, methods_wxPrintPageRange,
        0, SIP_NULLPTR,
        3, variables_wxPrintPageRange,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPrintPageRange,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxPrintPageRange,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxPrintPageRange,
    assign_wxPrintPageRange,
    array_wxPrintPageRange,
    copy_wxPrintPageRange,
    release_wxPrintPageRange,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxPrintPageRange,
    sizeof (::wxPrintPageRange),
};
