/////////////////////////////////////////////////////////////////////////////
// Name:        wx/private/lang_match.h
// Purpose:     Mapping of language matchings
// Author:      misc/languages/genlang.py
// Created:     2024-10-04
// Copyright:   (c) 2024 wxWidgets development team <vadim@wxwidgets.org>
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

// WARNING: Parts of this file are generated. See misc/languages/README for
// details.

#ifndef _WX_PRIVATE_LANG_MATCH_H_
#define _WX_PRIVATE_LANG_MATCH_H_

// ----------------------------------------------------------------------------
// Mapping of pairs of desired and supported languages to language distances
// ----------------------------------------------------------------------------

// --- --- --- generated code begins here --- --- ---

// The following data tables are generated by misc/languages/genlang.py
// When making changes, please put them into misc/languages/matchingtabl.txt

// Data table for matching languages
static const struct matchData_t
{
    const char* matchkey;
    int matchval;
}
tabMatchData[] =
{
    { "aa:ssy",              4 },
    { "ab:ru",              30 },
    { "af:nl",              20 },
    { "ak:en",              30 },
    { "am:en",              30 },
    { "am-Ethi:en-Latn",    10 },
    { "ar-Latn:ar-Arab",    20 },
    { "ay:es",              20 },
    { "az:ru",              30 },
    { "az-Latn:ru-Cyrl",    10 },
    { "be:ru",              20 },
    { "bem:en",             30 },
    { "bh:hi",              30 },
    { "bn:en",              30 },
    { "bn-Beng:en-Latn",    10 },
    { "bn-Latn:bn-Beng",    20 },
    { "bo:zh",              20 },
    { "bo-Tibt:zh-Hans",    10 },
    { "br:fr",              20 },
    { "bs:hr",               4 },
    { "bs:sh",               4 },
    { "ca:es",              20 },
    { "ceb:fil",            30 },
    { "chr:en",             20 },
    { "co:fr",              20 },
    { "cs:sk",              20 },
    { "cy:en",              20 },
    { "da:nb",               8 },
    { "da:no",               8 },
    { "ee:en",              30 },
    { "eo:en",              30 },
    { "eu:es",              20 },
    { "fo:da",              20 },
    { "fy:nl",              20 },
    { "ga:en",              20 },
    { "gd:en",              20 },
    { "gl:es",              20 },
    { "gn:es",              20 },
    { "gsw:de",              4 },
    { "gu:hi",              30 },
    { "gu-Latn:gu-Gujr",    20 },
    { "ha:en",              30 },
    { "haw:en",             20 },
    { "hi-Latn:hi-Deva",    20 },
    { "hr:bs",               4 },
    { "hr:sh",               4 },
    { "hy:ru",              30 },
    { "hy-Armn:ru-Cyrl",    10 },
    { "ia:en",              30 },
    { "id:ms",              10 },
    { "ig:en",              30 },
    { "is:en",              20 },
    { "ja-Hani:ja-Jpan",     5 },
    { "ja-Hira:ja-Hrkt",     5 },
    { "ja-Hira:ja-Jpan",     5 },
    { "ja-Hrkt:ja-Jpan",     5 },
    { "ja-Kana:ja-Hrkt",     5 },
    { "ja-Kana:ja-Jpan",     5 },
    { "ja-Latn:ja-Jpan",     5 },
    { "jv:id",              20 },
    { "ka:en",              30 },
    { "ka-Geor:en-Latn",    10 },
    { "kk:ru",              30 },
    { "km:en",              30 },
    { "km-Khmr:en-Latn",    10 },
    { "kn:en",              30 },
    { "kn-Knda:en-Latn",    10 },
    { "kn-Latn:kn-Knda",    20 },
    { "ko-Hang:ko-Kore",     5 },
    { "ko-Hani:ko-Kore",     5 },
    { "ko-Jamo:ko-Hang",     5 },
    { "ko-Jamo:ko-Kore",     5 },
    { "ku:tr",              30 },
    { "ky:ru",              30 },
    { "la:it",              20 },
    { "lb:de",               4 },
    { "lg:en",              30 },
    { "ln:fr",              30 },
    { "lo:en",              30 },
    { "lo-Laoo:en-Latn",    10 },
    { "mai:hi",             20 },
    { "mfe:en",             30 },
    { "mg:fr",              30 },
    { "mi:en",              20 },
    { "ml:en",              30 },
    { "ml-Latn:ml-Mlym",    20 },
    { "ml-Mlym:en-Latn",    10 },
    { "mn:ru",              30 },
    { "mr:hi",              30 },
    { "mr-Latn:mr-Deva",    20 },
    { "ms:id",              30 },
    { "mt:en",              30 },
    { "my:en",              30 },
    { "my-Mymr:en-Latn",    10 },
    { "nb:da",               8 },
    { "nb:nn",              20 },
    { "nb:no",               1 },
    { "ne:en",              30 },
    { "ne-Deva:en-Latn",    10 },
    { "nn:nb",              20 },
    { "nn:no",              20 },
    { "no:da",               8 },
    { "no:nb",               1 },
    { "no:nn",              20 },
    { "nso:en",             30 },
    { "nyn:en",             30 },
    { "oc:fr",              20 },
    { "om:en",              30 },
    { "or:en",              30 },
    { "or-Orya:en-Latn",    10 },
    { "pa:en",              30 },
    { "pa-Guru:en-Latn",    10 },
    { "pcm:en",             20 },
    { "ps:en",              30 },
    { "ps-Arab:en-Latn",    10 },
    { "qu:es",              30 },
    { "rm:de",              20 },
    { "rn:en",              30 },
    { "rw:fr",              30 },
    { "sa:hi",              30 },
    { "sd:en",              30 },
    { "sd-Arab:en-Latn",    10 },
    { "sh:bs",               4 },
    { "sh:hr",               4 },
    { "sh:sr",               4 },
    { "si:en",              30 },
    { "si-Sinh:en-Latn",    10 },
    { "sk:cs",              20 },
    { "sn:en",              30 },
    { "so:en",              30 },
    { "sq:en",              30 },
    { "sr:sh",               4 },
    { "sr-Cyrl:sr-Latn",     5 },
    { "sr-Latn:sr-Cyrl",     5 },
    { "ssy:aa",              4 },
    { "st:en",              30 },
    { "su:id",              20 },
    { "sw:en",              30 },
    { "ta:en",              30 },
    { "ta-Latn:ta-Taml",    20 },
    { "ta-Taml:en-Latn",    10 },
    { "te:en",              30 },
    { "te-Latn:te-Telu",    20 },
    { "te-Telu:en-Latn",    10 },
    { "tg:ru",              30 },
    { "ti:en",              30 },
    { "ti-Ethi:en-Latn",    10 },
    { "tk:ru",              30 },
    { "tk-Latn:ru-Cyrl",    10 },
    { "tn:en",              30 },
    { "to:en",              30 },
    { "tt:ru",              30 },
    { "ug:zh",              20 },
    { "ur:en",              30 },
    { "ur-Arab:en-Latn",    10 },
    { "uz:ru",              30 },
    { "uz-Latn:ru-Cyrl",    10 },
    { "wo:fr",              30 },
    { "xh:en",              30 },
    { "yi:en",              30 },
    { "yi-Hebr:en-Latn",    10 },
    { "yo:en",              30 },
    { "za:zh",              20 },
    { "za-Latn:zh-Hans",    10 },
    { "zh-Hani:zh-Hans",    20 },
    { "zh-Hani:zh-Hant",    20 },
    { "zh-Latn:zh-Hans",    20 },
    { "zu:en",              30 },
    { "*:*",                80 },
    { "*-*:*-*",            50 },
    { "*-*-*:*-*-*",         4 },
    { "ar-*-*:ar-*-*",       5 },
    { "en-*-*:en-*-*",       5 },
    { "es-*-*:es-*-*",       5 },
    { "pt-*-*:pt-*-*",       5 },
    { "zh-Hant-*:zh-Hant-*",   5 },

    { nullptr, 0 }
};
// --- --- --- generated code ends here --- --- ---

#endif // _WX_PRIVATE_LANG_MATCH_H_
