/////////////////////////////////////////////////////////////////////////////
// Name:        wx/osx/radiobut.h
// Purpose:     wxRadioButton class
// Author:      Stefan Csomor
// Created:     01/02/97
// Copyright:   (c) Stefan Csomor
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _WX_RADIOBUT_H_
#define _WX_RADIOBUT_H_

class WXDLLIMPEXP_CORE wxRadioButton: public wxRadioButtonBase
{
    wxDECLARE_DYNAMIC_CLASS(wxRadioButton);

public:
    wxRadioButton() = default;
    wxRadioButton(wxWindow *parent, wxWindowID id,
           const wxString& label,
           const wxPoint& pos = wxDefaultPosition,
           const wxSize& size = wxDefaultSize, long style = 0,
           const wxValidator& validator = wxDefaultValidator,
           const wxString& name = wxASCII_STR(wxRadioButtonNameStr))
    {
        Create(parent, id, label, pos, size, style, validator, name);
    }
    virtual ~wxRadioButton();

    bool Create(wxWindow *parent, wxWindowID id,
           const wxString& label,
           const wxPoint& pos = wxDefaultPosition,
           const wxSize& size = wxDefaultSize, long style = 0,
           const wxValidator& validator = wxDefaultValidator,
           const wxString& name = wxASCII_STR(wxRadioButtonNameStr));

    virtual void SetValue(bool val) override;
    virtual bool GetValue() const override;

    virtual bool HasTransparentBackground() override { return true; }

    // implementation

    void Command(wxCommandEvent& event) override;
    wxRadioButton *AddInCycle(wxRadioButton *cycle);
    void RemoveFromCycle();
    wxRadioButton *NextInCycle() {return m_cycle;}

    // osx specific event handling common for all osx-ports

    virtual bool OSXHandleClicked(double timestampsec) override;
  protected:

    wxRadioButton *m_cycle;
};

// Not implemented
#if 0
class WXDLLIMPEXP_FWD_CORE wxBitmap ;

WXDLLIMPEXP_DATA_CORE(extern const wxChar) wxBitmapRadioButtonNameStr[];

class WXDLLIMPEXP_CORE wxBitmapRadioButton: public wxRadioButton
{
  wxDECLARE_DYNAMIC_CLASS(wxBitmapRadioButton);
protected:
  wxBitmap *theButtonBitmap;
public:
  wxBitmapRadioButton() { theButtonBitmap = nullptr; }
  wxBitmapRadioButton(wxWindow *parent, wxWindowID id,
           const wxBitmap *label,
           const wxPoint& pos = wxDefaultPosition,
           const wxSize& size = wxDefaultSize, long style = 0,
           const wxValidator& validator = wxDefaultValidator,
           const wxString& name = wxBitmapRadioButtonNameStr)
  {
      Create(parent, id, label, pos, size, style, validator, name);
  }

  bool Create(wxWindow *parent, wxWindowID id,
           const wxBitmap *label,
           const wxPoint& pos = wxDefaultPosition,
           const wxSize& size = wxDefaultSize, long style = 0,
           const wxValidator& validator = wxDefaultValidator,
           const wxString& name = wxBitmapRadioButtonNameStr);

  virtual void SetLabel(const wxBitmap *label);
  virtual void SetValue(bool val) ;
  virtual bool GetValue() const ;
};
#endif

#endif
    // _WX_RADIOBUT_H_
