/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/gdicmn.h>
        #include <wx/dc.h>
        #include <wx/richtext/richtextbuffer.h>


PyDoc_STRVAR(doc_wxTextAttrDimensionConverter_GetPixels, "GetPixels(dim, direction=wx.HORIZONTAL) -> int\n"
"\n"
"Gets the pixel size for the given dimension.");

extern "C" {static PyObject *meth_wxTextAttrDimensionConverter_GetPixels(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimensionConverter_GetPixels(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension* dim;
        int direction = wxHORIZONTAL;
        const ::wxTextAttrDimensionConverter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|i", &sipSelf, sipType_wxTextAttrDimensionConverter, &sipCpp, sipType_wxTextAttrDimension, &dim, &direction))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPixels(*dim, direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimensionConverter, sipName_GetPixels, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimensionConverter_GetTenthsMM, "GetTenthsMM(dim) -> int\n"
"\n"
"Gets the mm size for the given dimension.");

extern "C" {static PyObject *meth_wxTextAttrDimensionConverter_GetTenthsMM(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimensionConverter_GetTenthsMM(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension* dim;
        const ::wxTextAttrDimensionConverter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrDimensionConverter, &sipCpp, sipType_wxTextAttrDimension, &dim))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTenthsMM(*dim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimensionConverter, sipName_GetTenthsMM, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimensionConverter_ConvertTenthsMMToPixels, "ConvertTenthsMMToPixels(units) -> int\n"
"\n"
"Converts tenths of a mm to pixels.");

extern "C" {static PyObject *meth_wxTextAttrDimensionConverter_ConvertTenthsMMToPixels(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimensionConverter_ConvertTenthsMMToPixels(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int units;
        const ::wxTextAttrDimensionConverter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_units,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrDimensionConverter, &sipCpp, &units))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ConvertTenthsMMToPixels(units);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimensionConverter, sipName_ConvertTenthsMMToPixels, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimensionConverter_ConvertPixelsToTenthsMM, "ConvertPixelsToTenthsMM(pixels) -> int\n"
"\n"
"Converts pixels to tenths of a mm.");

extern "C" {static PyObject *meth_wxTextAttrDimensionConverter_ConvertPixelsToTenthsMM(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimensionConverter_ConvertPixelsToTenthsMM(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int pixels;
        const ::wxTextAttrDimensionConverter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pixels,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrDimensionConverter, &sipCpp, &pixels))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ConvertPixelsToTenthsMM(pixels);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimensionConverter, sipName_ConvertPixelsToTenthsMM, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextAttrDimensionConverter(void *, int);}
static void release_wxTextAttrDimensionConverter(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextAttrDimensionConverter *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxTextAttrDimensionConverter(void *, Py_ssize_t, void *);}
static void assign_wxTextAttrDimensionConverter(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTextAttrDimensionConverter *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTextAttrDimensionConverter *>(sipSrc);
}


extern "C" {static void *copy_wxTextAttrDimensionConverter(const void *, Py_ssize_t);}
static void *copy_wxTextAttrDimensionConverter(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxTextAttrDimensionConverter(reinterpret_cast<const ::wxTextAttrDimensionConverter *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTextAttrDimensionConverter(sipSimpleWrapper *);}
static void dealloc_wxTextAttrDimensionConverter(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextAttrDimensionConverter(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTextAttrDimensionConverter(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTextAttrDimensionConverter(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxTextAttrDimensionConverter *sipCpp = SIP_NULLPTR;

    {
        ::wxReadOnlyDC* dc;
        double scale = 1;
        const ::wxSize& parentSizedef = wxDefaultSize;
        const ::wxSize* parentSize = &parentSizedef;
        int parentSizeState = 0;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_scale,
            sipName_parentSize,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9|dJ1", sipType_wxReadOnlyDC, &dc, &scale, sipType_wxSize, &parentSize, &parentSizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTextAttrDimensionConverter(*dc, scale, *parentSize);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(parentSize), sipType_wxSize, parentSizeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        int ppi;
        double scale = 1;
        const ::wxSize& parentSizedef = wxDefaultSize;
        const ::wxSize* parentSize = &parentSizedef;
        int parentSizeState = 0;

        static const char *sipKwdList[] = {
            sipName_ppi,
            sipName_scale,
            sipName_parentSize,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "i|dJ1", &ppi, &scale, sipType_wxSize, &parentSize, &parentSizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTextAttrDimensionConverter(ppi, scale, *parentSize);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(parentSize), sipType_wxSize, parentSizeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxTextAttrDimensionConverter* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxTextAttrDimensionConverter, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTextAttrDimensionConverter(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxTextAttrDimensionConverter[] = {
    {sipName_ConvertPixelsToTenthsMM, SIP_MLMETH_CAST(meth_wxTextAttrDimensionConverter_ConvertPixelsToTenthsMM), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimensionConverter_ConvertPixelsToTenthsMM},
    {sipName_ConvertTenthsMMToPixels, SIP_MLMETH_CAST(meth_wxTextAttrDimensionConverter_ConvertTenthsMMToPixels), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimensionConverter_ConvertTenthsMMToPixels},
    {sipName_GetPixels, SIP_MLMETH_CAST(meth_wxTextAttrDimensionConverter_GetPixels), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimensionConverter_GetPixels},
    {sipName_GetTenthsMM, SIP_MLMETH_CAST(meth_wxTextAttrDimensionConverter_GetTenthsMM), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimensionConverter_GetTenthsMM}
};


extern "C" {static PyObject *varget_wxTextAttrDimensionConverter_m_parentSize(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrDimensionConverter_m_parentSize(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
    ::wxSize*sipVal;
    ::wxTextAttrDimensionConverter *sipCpp = reinterpret_cast< ::wxTextAttrDimensionConverter *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -47);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_parentSize;

    sipPy = sipConvertFromType(sipVal, sipType_wxSize, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -21, sipPySelf);
        sipKeepReference(sipPySelf, -47, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextAttrDimensionConverter_m_parentSize(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrDimensionConverter_m_parentSize(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::wxSize*sipVal;
    ::wxTextAttrDimensionConverter *sipCpp = reinterpret_cast< ::wxTextAttrDimensionConverter *>(sipSelf);

    int sipIsErr = 0;
    int sipValState;
    sipVal = reinterpret_cast< ::wxSize *>(sipForceConvertToType(sipPy, sipType_wxSize, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_parentSize = *sipVal;

    sipReleaseType(sipVal, sipType_wxSize, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrDimensionConverter_m_ppi(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrDimensionConverter_m_ppi(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
    ::wxTextAttrDimensionConverter *sipCpp = reinterpret_cast< ::wxTextAttrDimensionConverter *>(sipSelf);

    sipVal = sipCpp->m_ppi;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxTextAttrDimensionConverter_m_ppi(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrDimensionConverter_m_ppi(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::wxTextAttrDimensionConverter *sipCpp = reinterpret_cast< ::wxTextAttrDimensionConverter *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_ppi = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrDimensionConverter_m_scale(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrDimensionConverter_m_scale(void *sipSelf, PyObject *, PyObject *)
{
    double sipVal;
    ::wxTextAttrDimensionConverter *sipCpp = reinterpret_cast< ::wxTextAttrDimensionConverter *>(sipSelf);

    sipVal = sipCpp->m_scale;

    return PyFloat_FromDouble(sipVal);
}


extern "C" {static int varset_wxTextAttrDimensionConverter_m_scale(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrDimensionConverter_m_scale(void *sipSelf, PyObject *sipPy, PyObject *)
{
    double sipVal;
    ::wxTextAttrDimensionConverter *sipCpp = reinterpret_cast< ::wxTextAttrDimensionConverter *>(sipSelf);

    sipVal = PyFloat_AsDouble(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_scale = sipVal;

    return 0;
}

sipVariableDef variables_wxTextAttrDimensionConverter[] = {
    {InstanceVariable, sipName_m_parentSize, (PyMethodDef *)varget_wxTextAttrDimensionConverter_m_parentSize, (PyMethodDef *)varset_wxTextAttrDimensionConverter_m_parentSize, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_ppi, (PyMethodDef *)varget_wxTextAttrDimensionConverter_m_ppi, (PyMethodDef *)varset_wxTextAttrDimensionConverter_m_ppi, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_scale, (PyMethodDef *)varget_wxTextAttrDimensionConverter_m_scale, (PyMethodDef *)varset_wxTextAttrDimensionConverter_m_scale, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxTextAttrDimensionConverter, "TextAttrDimensionConverter(dc, scale=1.0, parentSize=wx.DefaultSize) -> None\n"
"TextAttrDimensionConverter(ppi, scale=1.0, parentSize=wx.DefaultSize) -> None\n"
"\n"
"A class to make it easier to convert dimensions.");


sipClassTypeDef sipTypeDef__richtext_wxTextAttrDimensionConverter = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxTextAttrDimensionConverter,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_TextAttrDimensionConverter,
        {0, 0, 1},
        4, methods_wxTextAttrDimensionConverter,
        0, SIP_NULLPTR,
        3, variables_wxTextAttrDimensionConverter,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxTextAttrDimensionConverter,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxTextAttrDimensionConverter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxTextAttrDimensionConverter,
    assign_wxTextAttrDimensionConverter,
    SIP_NULLPTR,
    copy_wxTextAttrDimensionConverter,
    release_wxTextAttrDimensionConverter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxTextAttrDimensionConverter),
};
