/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html2.h"
        #include <wx/webview.h>



PyDoc_STRVAR(doc_wxWebViewConfiguration_GetNativeConfiguration, "GetNativeConfiguration() -> Any\n"
"\n"
"Returns the pointer to the native configuration used during creation\n"
"of a wxWebView.");

extern "C" {static PyObject *meth_wxWebViewConfiguration_GetNativeConfiguration(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewConfiguration_GetNativeConfiguration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxWebViewConfiguration *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewConfiguration, &sipCpp))
        {
            void*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxWebViewConfiguration::GetNativeConfiguration() : sipCpp->GetNativeConfiguration());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewConfiguration, sipName_GetNativeConfiguration, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewConfiguration_GetBackend, "GetBackend() -> str\n"
"\n"
"Returns the backend identifier for which this configuration was\n"
"created.");

extern "C" {static PyObject *meth_wxWebViewConfiguration_GetBackend(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewConfiguration_GetBackend(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxWebViewConfiguration *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewConfiguration, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetBackend());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewConfiguration, sipName_GetBackend, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewConfiguration_SetDataPath, "SetDataPath(path) -> None\n"
"\n"
"Set the data path for the webview.");

extern "C" {static PyObject *meth_wxWebViewConfiguration_SetDataPath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxWebViewConfiguration_SetDataPath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* path;
        int pathState = 0;
        ::wxWebViewConfiguration *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxWebViewConfiguration, &sipCpp, sipType_wxString, &path, &pathState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDataPath(*path);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(path), sipType_wxString, pathState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewConfiguration, sipName_SetDataPath, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewConfiguration_GetDataPath, "GetDataPath() -> str\n"
"\n"
"Returns the data path for the webview.");

extern "C" {static PyObject *meth_wxWebViewConfiguration_GetDataPath(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewConfiguration_GetDataPath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxWebViewConfiguration *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewConfiguration, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetDataPath());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewConfiguration, sipName_GetDataPath, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewConfiguration_EnablePersistentStorage, "EnablePersistentStorage(enable) -> bool\n"
"\n"
"Allows to disable persistent storage for the webview.");

extern "C" {static PyObject *meth_wxWebViewConfiguration_EnablePersistentStorage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxWebViewConfiguration_EnablePersistentStorage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool enable;
        ::wxWebViewConfiguration *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxWebViewConfiguration, &sipCpp, &enable))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EnablePersistentStorage(enable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewConfiguration, sipName_EnablePersistentStorage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxWebViewConfiguration(void *, int);}
static void release_wxWebViewConfiguration(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxWebViewConfiguration *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxWebViewConfiguration(sipSimpleWrapper *);}
static void dealloc_wxWebViewConfiguration(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxWebViewConfiguration(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxWebViewConfiguration[] = {
    {sipName_EnablePersistentStorage, SIP_MLMETH_CAST(meth_wxWebViewConfiguration_EnablePersistentStorage), METH_VARARGS|METH_KEYWORDS, doc_wxWebViewConfiguration_EnablePersistentStorage},
    {sipName_GetBackend, meth_wxWebViewConfiguration_GetBackend, METH_VARARGS, doc_wxWebViewConfiguration_GetBackend},
    {sipName_GetDataPath, meth_wxWebViewConfiguration_GetDataPath, METH_VARARGS, doc_wxWebViewConfiguration_GetDataPath},
    {sipName_GetNativeConfiguration, meth_wxWebViewConfiguration_GetNativeConfiguration, METH_VARARGS, doc_wxWebViewConfiguration_GetNativeConfiguration},
    {sipName_SetDataPath, SIP_MLMETH_CAST(meth_wxWebViewConfiguration_SetDataPath), METH_VARARGS|METH_KEYWORDS, doc_wxWebViewConfiguration_SetDataPath}
};

sipVariableDef variables_wxWebViewConfiguration[] = {
    {PropertyVariable, sipName_NativeConfiguration, &methods_wxWebViewConfiguration[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DataPath, &methods_wxWebViewConfiguration[2], &methods_wxWebViewConfiguration[4], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Backend, &methods_wxWebViewConfiguration[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxWebViewConfiguration, "This class allows access to web view configuration options and\n"
"settings, that have to be specified before placing a webview in a\n"
"window with wxWebView::Create().");


sipClassTypeDef sipTypeDef__html2_wxWebViewConfiguration = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxWebViewConfiguration,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_WebViewConfiguration,
        {0, 0, 1},
        5, methods_wxWebViewConfiguration,
        0, SIP_NULLPTR,
        3, variables_wxWebViewConfiguration,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxWebViewConfiguration,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxWebViewConfiguration,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxWebViewConfiguration,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
