/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/splitter.h>
        #include <wx/splitter.h>
        #include <wx/event.h>
        #include <wx/window.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxSplitterEvent : public ::wxSplitterEvent
{
public:
    sipwxSplitterEvent(::wxEventType, ::wxSplitterWindow*);
    sipwxSplitterEvent(const ::wxSplitterEvent&);
    virtual ~sipwxSplitterEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxEvent* Clone() const SIP_OVERRIDE;
    ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxSplitterEvent(const sipwxSplitterEvent &);
    sipwxSplitterEvent &operator = (const sipwxSplitterEvent &);

    char sipPyMethods[2];
};

sipwxSplitterEvent::sipwxSplitterEvent(::wxEventType eventType, ::wxSplitterWindow*splitter): ::wxSplitterEvent(eventType, splitter), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxSplitterEvent::sipwxSplitterEvent(const ::wxSplitterEvent& a0): ::wxSplitterEvent(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxSplitterEvent::~sipwxSplitterEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxEvent* sipwxSplitterEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Clone);

    if (!sipMeth)
        return ::wxSplitterEvent::Clone();

    extern ::wxEvent* sipVH__core_102(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_102(sipGILState, 0, sipPySelf, sipMeth);
}

::wxEventCategory sipwxSplitterEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetEventCategory);

    if (!sipMeth)
        return ::wxSplitterEvent::GetEventCategory();

    extern ::wxEventCategory sipVH__core_103(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_103(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxSplitterEvent_GetSashPosition, "GetSashPosition() -> int\n"
"\n"
"Returns the new sash position.");

extern "C" {static PyObject *meth_wxSplitterEvent_GetSashPosition(PyObject *, PyObject *);}
static PyObject *meth_wxSplitterEvent_GetSashPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSplitterEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSplitterEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSashPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_SplitterEvent, sipName_GetSashPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSplitterEvent_GetWindowBeingRemoved, "GetWindowBeingRemoved() -> Window\n"
"\n"
"Returns a pointer to the window being removed when a splitter window\n"
"is unsplit.");

extern "C" {static PyObject *meth_wxSplitterEvent_GetWindowBeingRemoved(PyObject *, PyObject *);}
static PyObject *meth_wxSplitterEvent_GetWindowBeingRemoved(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSplitterEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSplitterEvent, &sipCpp))
        {
            ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWindowBeingRemoved();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxWindow, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_SplitterEvent, sipName_GetWindowBeingRemoved, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSplitterEvent_GetX, "GetX() -> int\n"
"\n"
"Returns the x coordinate of the double-click point.");

extern "C" {static PyObject *meth_wxSplitterEvent_GetX(PyObject *, PyObject *);}
static PyObject *meth_wxSplitterEvent_GetX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSplitterEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSplitterEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetX();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_SplitterEvent, sipName_GetX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSplitterEvent_GetY, "GetY() -> int\n"
"\n"
"Returns the y coordinate of the double-click point.");

extern "C" {static PyObject *meth_wxSplitterEvent_GetY(PyObject *, PyObject *);}
static PyObject *meth_wxSplitterEvent_GetY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSplitterEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSplitterEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetY();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_SplitterEvent, sipName_GetY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSplitterEvent_SetSashPosition, "SetSashPosition(pos) -> None\n"
"\n"
"In the case of wxEVT_SPLITTER_SASH_POS_CHANGED events, sets the new\n"
"sash position.");

extern "C" {static PyObject *meth_wxSplitterEvent_SetSashPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSplitterEvent_SetSashPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int pos;
        ::wxSplitterEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxSplitterEvent, &sipCpp, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSashPosition(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_SplitterEvent, sipName_SetSashPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSplitterEvent_SetSize, "SetSize(oldSize, newSize) -> None\n"
"\n"
"Sets the size values of the window size.");

extern "C" {static PyObject *meth_wxSplitterEvent_SetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSplitterEvent_SetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int oldSize;
        int newSize;
        ::wxSplitterEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_oldSize,
            sipName_newSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxSplitterEvent, &sipCpp, &oldSize, &newSize))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSize(oldSize, newSize);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_SplitterEvent, sipName_SetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSplitterEvent_GetOldSize, "GetOldSize() -> int\n"
"\n"
"Returns the old size before the update.");

extern "C" {static PyObject *meth_wxSplitterEvent_GetOldSize(PyObject *, PyObject *);}
static PyObject *meth_wxSplitterEvent_GetOldSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSplitterEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSplitterEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOldSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_SplitterEvent, sipName_GetOldSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSplitterEvent_Clone, "Clone(self) -> Event|None");

extern "C" {static PyObject *meth_wxSplitterEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxSplitterEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxSplitterEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSplitterEvent, &sipCpp))
        {
            ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxSplitterEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxEvent, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_SplitterEvent, sipName_Clone, doc_wxSplitterEvent_Clone);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxSplitterEvent(void *, const sipTypeDef *);}
static void *cast_wxSplitterEvent(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxSplitterEvent *sipCpp = reinterpret_cast< ::wxSplitterEvent *>(sipCppV);

    if (targetType == sipType_wxSplitterEvent)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxNotifyEvent)->ctd_cast(static_cast< ::wxNotifyEvent *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxSplitterEvent(void *, int);}
static void release_wxSplitterEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxSplitterEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxSplitterEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxSplitterEvent(sipSimpleWrapper *);}
static void dealloc_wxSplitterEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxSplitterEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxSplitterEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxSplitterEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxSplitterEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxSplitterEvent *sipCpp = SIP_NULLPTR;

    {
        ::wxEventType eventType = wxEVT_NULL;
        ::wxSplitterWindow* splitter = nullptr;

        static const char *sipKwdList[] = {
            sipName_eventType,
            sipName_splitter,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|iJ8", &eventType, sipType_wxSplitterWindow, &splitter))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxSplitterEvent(eventType, splitter);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxSplitterEvent* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxSplitterEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxSplitterEvent(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxSplitterEvent[] = {{396, 255, 1}};


static PyMethodDef methods_wxSplitterEvent[] = {
    {sipName_Clone, meth_wxSplitterEvent_Clone, METH_VARARGS, doc_wxSplitterEvent_Clone},
    {sipName_GetOldSize, meth_wxSplitterEvent_GetOldSize, METH_VARARGS, doc_wxSplitterEvent_GetOldSize},
    {sipName_GetSashPosition, meth_wxSplitterEvent_GetSashPosition, METH_VARARGS, doc_wxSplitterEvent_GetSashPosition},
    {sipName_GetWindowBeingRemoved, meth_wxSplitterEvent_GetWindowBeingRemoved, METH_VARARGS, doc_wxSplitterEvent_GetWindowBeingRemoved},
    {sipName_GetX, meth_wxSplitterEvent_GetX, METH_VARARGS, doc_wxSplitterEvent_GetX},
    {sipName_GetY, meth_wxSplitterEvent_GetY, METH_VARARGS, doc_wxSplitterEvent_GetY},
    {sipName_SetSashPosition, SIP_MLMETH_CAST(meth_wxSplitterEvent_SetSashPosition), METH_VARARGS|METH_KEYWORDS, doc_wxSplitterEvent_SetSashPosition},
    {sipName_SetSize, SIP_MLMETH_CAST(meth_wxSplitterEvent_SetSize), METH_VARARGS|METH_KEYWORDS, doc_wxSplitterEvent_SetSize}
};

sipVariableDef variables_wxSplitterEvent[] = {
    {PropertyVariable, sipName_Y, &methods_wxSplitterEvent[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_X, &methods_wxSplitterEvent[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_WindowBeingRemoved, &methods_wxSplitterEvent[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_SashPosition, &methods_wxSplitterEvent[2], &methods_wxSplitterEvent[6], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OldSize, &methods_wxSplitterEvent[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxSplitterEvent, "SplitterEvent(eventType=wxEVT_NULL, splitter=nullptr) -> None\n"
"\n"
"This class represents the events generated by a splitter control.");


sipClassTypeDef sipTypeDef__core_wxSplitterEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxSplitterEvent,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_SplitterEvent,
        {0, 0, 1},
        8, methods_wxSplitterEvent,
        0, SIP_NULLPTR,
        5, variables_wxSplitterEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxSplitterEvent,
    -1,
    -1,
    supers_wxSplitterEvent,
    SIP_NULLPTR,
    init_type_wxSplitterEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxSplitterEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxSplitterEvent,
    cast_wxSplitterEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxSplitterEvent),
};
