/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/dc.h>
        #include <wx/font.h>
        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
        #include <wx/dc.h>
        #include <wx/affinematrix2d.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    wxArrayInt* _wxReadOnlyDC_GetPartialTextExtents(const wxReadOnlyDC* self, const wxString *text)
    {
        wxArrayInt rval;
        self->GetPartialTextExtents(*text, rval);
        return new wxArrayInt(rval);
    }


PyDoc_STRVAR(doc_wxReadOnlyDC_CanDrawBitmap, "CanDrawBitmap() -> bool\n"
"\n"
"Does the DC support drawing bitmaps?");

extern "C" {static PyObject *meth_wxReadOnlyDC_CanDrawBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_CanDrawBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanDrawBitmap();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_CanDrawBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_CanGetTextExtent, "CanGetTextExtent() -> bool\n"
"\n"
"Does the DC support calculating the size required to draw text?");

extern "C" {static PyObject *meth_wxReadOnlyDC_CanGetTextExtent(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_CanGetTextExtent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanGetTextExtent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_CanGetTextExtent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_DeviceToLogicalX, "DeviceToLogicalX(x) -> int\n"
"\n"
"Convert device X coordinate to logical coordinate, using the current\n"
"mapping mode, user scale factor, device origin and axis orientation.");

extern "C" {static PyObject *meth_wxReadOnlyDC_DeviceToLogicalX(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_DeviceToLogicalX(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeviceToLogicalX(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_DeviceToLogicalX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_DeviceToLogicalXRel, "DeviceToLogicalXRel(x) -> int\n"
"\n"
"Convert device X coordinate to relative logical coordinate, using the\n"
"current mapping mode and user scale factor but ignoring the axis\n"
"orientation.");

extern "C" {static PyObject *meth_wxReadOnlyDC_DeviceToLogicalXRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_DeviceToLogicalXRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeviceToLogicalXRel(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_DeviceToLogicalXRel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_DeviceToLogicalY, "DeviceToLogicalY(y) -> int\n"
"\n"
"Converts device Y coordinate to logical coordinate, using the current\n"
"mapping mode, user scale factor, device origin and axis orientation.");

extern "C" {static PyObject *meth_wxReadOnlyDC_DeviceToLogicalY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_DeviceToLogicalY(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord y;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &y))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeviceToLogicalY(y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_DeviceToLogicalY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_DeviceToLogicalYRel, "DeviceToLogicalYRel(y) -> int\n"
"\n"
"Convert device Y coordinate to relative logical coordinate, using the\n"
"current mapping mode and user scale factor but ignoring the axis\n"
"orientation.");

extern "C" {static PyObject *meth_wxReadOnlyDC_DeviceToLogicalYRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_DeviceToLogicalYRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord y;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &y))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeviceToLogicalYRel(y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_DeviceToLogicalYRel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_LogicalToDeviceX, "LogicalToDeviceX(x) -> int\n"
"\n"
"Converts logical X coordinate to device coordinate, using the current\n"
"mapping mode, user scale factor, device origin and axis orientation.");

extern "C" {static PyObject *meth_wxReadOnlyDC_LogicalToDeviceX(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_LogicalToDeviceX(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LogicalToDeviceX(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_LogicalToDeviceX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_LogicalToDeviceXRel, "LogicalToDeviceXRel(x) -> int\n"
"\n"
"Converts logical X coordinate to relative device coordinate, using the\n"
"current mapping mode and user scale factor but ignoring the axis\n"
"orientation.");

extern "C" {static PyObject *meth_wxReadOnlyDC_LogicalToDeviceXRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_LogicalToDeviceXRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LogicalToDeviceXRel(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_LogicalToDeviceXRel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_LogicalToDeviceY, "LogicalToDeviceY(y) -> int\n"
"\n"
"Converts logical Y coordinate to device coordinate, using the current\n"
"mapping mode, user scale factor, device origin and axis orientation.");

extern "C" {static PyObject *meth_wxReadOnlyDC_LogicalToDeviceY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_LogicalToDeviceY(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord y;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &y))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LogicalToDeviceY(y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_LogicalToDeviceY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_LogicalToDeviceYRel, "LogicalToDeviceYRel(y) -> int\n"
"\n"
"Converts logical Y coordinate to relative device coordinate, using the\n"
"current mapping mode and user scale factor but ignoring the axis\n"
"orientation.");

extern "C" {static PyObject *meth_wxReadOnlyDC_LogicalToDeviceYRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_LogicalToDeviceYRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord y;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &y))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LogicalToDeviceYRel(y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_LogicalToDeviceYRel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_DeviceToLogical, "DeviceToLogical(x, y) -> Point\n"
"DeviceToLogical(pt) -> Point\n"
"\n"
"Converts device (x, y) coordinates to logical coordinates taking into\n"
"account all applied transformations like the current mapping mode,\n"
"scale factors, device origin, axes orientation, affine transformation.\n"
"");

extern "C" {static PyObject *meth_wxReadOnlyDC_DeviceToLogical(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_DeviceToLogical(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x, &y))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->DeviceToLogical(x, y));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->DeviceToLogical(*pt));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_DeviceToLogical, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_DeviceToLogicalRel, "DeviceToLogicalRel(x, y) -> Size\n"
"DeviceToLogicalRel(dim) -> Size\n"
"\n"
"Converts device x, y coordinates to relative logical coordinates\n"
"taking into account all applied transformations like the current\n"
"mapping mode, scale factors, affine transformation.\n"
"");

extern "C" {static PyObject *meth_wxReadOnlyDC_DeviceToLogicalRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_DeviceToLogicalRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int x;
        int y;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x, &y))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->DeviceToLogicalRel(x, y));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    {
        const ::wxSize* dim;
        int dimState = 0;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxSize, &dim, &dimState))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->DeviceToLogicalRel(*dim));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(dim), sipType_wxSize, dimState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_DeviceToLogicalRel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_LogicalToDevice, "LogicalToDevice(x, y) -> Point\n"
"LogicalToDevice(pt) -> Point\n"
"\n"
"Converts logical (x, y) coordinates to device coordinates taking into\n"
"account all applied transformations like the current mapping mode,\n"
"scale factors, device origin, axes orientation, affine transformation.\n"
"");

extern "C" {static PyObject *meth_wxReadOnlyDC_LogicalToDevice(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_LogicalToDevice(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x, &y))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->LogicalToDevice(x, y));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->LogicalToDevice(*pt));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_LogicalToDevice, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_LogicalToDeviceRel, "LogicalToDeviceRel(x, y) -> Size\n"
"LogicalToDeviceRel(dim) -> Size\n"
"\n"
"Converts logical x, y coordinates to relative device coordinates\n"
"taking into account all applied transformations like the current\n"
"mapping mode, scale factors, affine transformation.\n"
"");

extern "C" {static PyObject *meth_wxReadOnlyDC_LogicalToDeviceRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_LogicalToDeviceRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int x;
        int y;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x, &y))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->LogicalToDeviceRel(x, y));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    {
        const ::wxSize* dim;
        int dimState = 0;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxSize, &dim, &dimState))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->LogicalToDeviceRel(*dim));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(dim), sipType_wxSize, dimState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_LogicalToDeviceRel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_SetAxisOrientation, "SetAxisOrientation(xLeftRight, yBottomUp) -> None\n"
"\n"
"Sets the x and y axis orientation (i.e. the direction from lowest to\n"
"highest values on the axis).");

extern "C" {static PyObject *meth_wxReadOnlyDC_SetAxisOrientation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_SetAxisOrientation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool xLeftRight;
        bool yBottomUp;
        ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xLeftRight,
            sipName_yBottomUp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bbb", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &xLeftRight, &yBottomUp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAxisOrientation(xLeftRight, yBottomUp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_SetAxisOrientation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_SetDeviceOrigin, "SetDeviceOrigin(x, y) -> None\n"
"\n"
"Sets the device origin (i.e. the origin in pixels after scaling has\n"
"been applied).");

extern "C" {static PyObject *meth_wxReadOnlyDC_SetDeviceOrigin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_SetDeviceOrigin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDeviceOrigin(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_SetDeviceOrigin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_SetMapMode, "SetMapMode(mode) -> None\n"
"\n"
"The mapping mode of the device context defines the unit of measurement\n"
"used to convert logical units to device units.");

extern "C" {static PyObject *meth_wxReadOnlyDC_SetMapMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_SetMapMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxMappingMode mode;
        ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxMappingMode, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMapMode(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_SetMapMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_SetUserScale, "SetUserScale(xScale, yScale) -> None\n"
"\n"
"Sets the user scaling factor, useful for applications which require\n"
"'zooming'.");

extern "C" {static PyObject *meth_wxReadOnlyDC_SetUserScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_SetUserScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double xScale;
        double yScale;
        ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xScale,
            sipName_yScale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &xScale, &yScale))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUserScale(xScale, yScale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_SetUserScale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_SetLogicalScale, "SetLogicalScale(x, y) -> None\n"
"\n"
"Set the scale to use for translating wxDC coordinates to the physical\n"
"pixels.");

extern "C" {static PyObject *meth_wxReadOnlyDC_SetLogicalScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_SetLogicalScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double x;
        double y;
        ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLogicalScale(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_SetLogicalScale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetLogicalScale, "GetLogicalScale() -> Tuple[float, float]\n"
"\n"
"Return the scale set by the last call to SetLogicalScale().");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetLogicalScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetLogicalScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double x;
        double y;
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetLogicalScale(&x, &y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(dd)", x, y);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetLogicalScale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_SetLogicalOrigin, "SetLogicalOrigin(x, y) -> None\n"
"\n"
"Change the offset used for translating wxDC coordinates.");

extern "C" {static PyObject *meth_wxReadOnlyDC_SetLogicalOrigin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_SetLogicalOrigin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLogicalOrigin(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_SetLogicalOrigin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetLogicalOrigin, "GetLogicalOrigin() -> Tuple[int, int]\n"
"\n"
"Return the coordinates of the logical point (0, 0).");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetLogicalOrigin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetLogicalOrigin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetLogicalOrigin(&x, &y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(ii)", x, y);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetLogicalOrigin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_CanUseTransformMatrix, "CanUseTransformMatrix() -> bool\n"
"\n"
"Check if the use of transformation matrix is supported by the current\n"
"system.");

extern "C" {static PyObject *meth_wxReadOnlyDC_CanUseTransformMatrix(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_CanUseTransformMatrix(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanUseTransformMatrix();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_CanUseTransformMatrix, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_SetTransformMatrix, "SetTransformMatrix(matrix) -> bool\n"
"\n"
"Set the transformation matrix.");

extern "C" {static PyObject *meth_wxReadOnlyDC_SetTransformMatrix(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_SetTransformMatrix(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAffineMatrix2D* matrix;
        ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_matrix,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxAffineMatrix2D, &matrix))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetTransformMatrix(*matrix);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_SetTransformMatrix, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetTransformMatrix, "GetTransformMatrix() -> AffineMatrix2D\n"
"\n"
"Return the transformation matrix used by this device context.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetTransformMatrix(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetTransformMatrix(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxAffineMatrix2D*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxAffineMatrix2D(sipCpp->GetTransformMatrix());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxAffineMatrix2D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetTransformMatrix, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_ResetTransformMatrix, "ResetTransformMatrix() -> None\n"
"\n"
"Revert the transformation matrix to identity matrix.");

extern "C" {static PyObject *meth_wxReadOnlyDC_ResetTransformMatrix(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_ResetTransformMatrix(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ResetTransformMatrix();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_ResetTransformMatrix, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetCharHeight, "GetCharHeight() -> int\n"
"\n"
"Gets the character height of the currently set font.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetCharHeight(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetCharHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCharHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetCharHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetCharWidth, "GetCharWidth() -> int\n"
"\n"
"Gets the average character width of the currently set font.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetCharWidth(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetCharWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCharWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetCharWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetFontMetrics, "GetFontMetrics() -> FontMetrics\n"
"\n"
"Returns the various font characteristics.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetFontMetrics(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetFontMetrics(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxFontMetrics*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFontMetrics(sipCpp->GetFontMetrics());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFontMetrics, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetFontMetrics, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetFullMultiLineTextExtent, "GetFullMultiLineTextExtent(string, font=nullptr) -> Tuple[int, int, int]\n"
"\n"
"Gets the dimensions of the string as it would be drawn.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetFullMultiLineTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetFullMultiLineTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* string;
        int stringState = 0;
        ::wxCoord w;
        ::wxCoord h;
        ::wxCoord heightLine;
        const ::wxFont* font = nullptr;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_string,
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J8", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxString, &string, &stringState, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetMultiLineTextExtent(*string, &w, &h, &heightLine, font);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string), sipType_wxString, stringState);

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(iii)", w, h, heightLine);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetFullMultiLineTextExtent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetPartialTextExtents, "GetPartialTextExtents(text) -> List[int]\n"
"\n"
"Fills the widths array with the widths from the beginning of text to\n"
"the corresponding character of text.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetPartialTextExtents(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetPartialTextExtents(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* text;
        int textState = 0;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxString, &text, &textState))
        {
            ::wxArrayInt*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxReadOnlyDC_GetPartialTextExtents(sipCpp, text);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayInt, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetPartialTextExtents, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetFullTextExtent, "GetFullTextExtent(string, font=nullptr) -> Tuple[int, int, int, int]\n"
"\n"
"Gets the dimensions of the string as it would be drawn.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetFullTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetFullTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* string;
        int stringState = 0;
        ::wxCoord w;
        ::wxCoord h;
        ::wxCoord descent;
        ::wxCoord externalLeading;
        const ::wxFont* font = nullptr;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_string,
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J8", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxString, &string, &stringState, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetTextExtent(*string, &w, &h, &descent, &externalLeading, font);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string), sipType_wxString, stringState);

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(iiii)", w, h, descent, externalLeading);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetFullTextExtent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the DC is ok to use.");

extern "C" {static PyObject *meth_wxReadOnlyDC_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetContentScaleFactor, "GetContentScaleFactor() -> float\n"
"\n"
"Returns the factor used for converting logical pixels to physical\n"
"ones.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetContentScaleFactor(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetContentScaleFactor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetContentScaleFactor();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetContentScaleFactor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetDepth, "GetDepth() -> int\n"
"\n"
"Returns the depth (number of bits/pixel) of this DC.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetDepth(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetDepth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDepth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetDepth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetDeviceOrigin, "GetDeviceOrigin() -> Point\n"
"\n"
"Returns the current device origin.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetDeviceOrigin(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetDeviceOrigin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->GetDeviceOrigin());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetDeviceOrigin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetMapMode, "GetMapMode() -> MappingMode\n"
"\n"
"Gets the current mapping mode for the device context.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetMapMode(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetMapMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxMappingMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMapMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxMappingMode);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetMapMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetPPI, "GetPPI() -> Size\n"
"\n"
"Returns the resolution of the device in pixels per inch.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetPPI(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetPPI(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetPPI());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetPPI, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_FromDIP, "FromDIP(sz) -> Size\n"
"FromDIP(pt) -> Point\n"
"FromDIP(d) -> int\n"
"\n"
"Convert DPI-independent pixel values to the value in pixels\n"
"appropriate for the DC.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxReadOnlyDC_FromDIP(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_FromDIP(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSize* sz;
        int szState = 0;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxSize, &sz, &szState))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->FromDIP(*sz));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->FromDIP(*pt));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    {
        int d;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_d,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &d))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FromDIP(d);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_FromDIP, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_ToDIP, "ToDIP(sz) -> Size\n"
"ToDIP(pt) -> Point\n"
"ToDIP(d) -> int\n"
"\n"
"Convert pixel values of the current DC to DPI-independent pixel\n"
"values.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxReadOnlyDC_ToDIP(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_ToDIP(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSize* sz;
        int szState = 0;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxSize, &sz, &szState))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->ToDIP(*sz));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->ToDIP(*pt));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    {
        int d;
        const ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_d,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, &d))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ToDIP(d);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_ToDIP, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetSize, "GetSize() -> Size\n"
"\n"
"This is an overloaded member function, provided for convenience. It\n"
"differs from the above function only in what argument(s) it accepts.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetSizeMM, "GetSizeMM() -> Size\n"
"\n"
"This is an overloaded member function, provided for convenience. It\n"
"differs from the above function only in what argument(s) it accepts.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetSizeMM(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetSizeMM(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetSizeMM());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetSizeMM, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetUserScale, "GetUserScale() -> Tuple[float, float]\n"
"\n"
"Gets the current user scale factor.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetUserScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetUserScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double x;
        double y;
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetUserScale(&x, &y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(dd)", x, y);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetUserScale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetFont, "GetFont() -> Font\n"
"\n"
"Gets the current font.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetFont(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->GetFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_GetLayoutDirection, "GetLayoutDirection() -> LayoutDirection\n"
"\n"
"Gets the current layout direction of the device context.");

extern "C" {static PyObject *meth_wxReadOnlyDC_GetLayoutDirection(PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_GetLayoutDirection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxReadOnlyDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxReadOnlyDC, &sipCpp))
        {
            ::wxLayoutDirection sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLayoutDirection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxLayoutDirection);
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_GetLayoutDirection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_SetFont, "SetFont(font) -> None\n"
"\n"
"Sets the current font for the DC.");

extern "C" {static PyObject *meth_wxReadOnlyDC_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont* font;
        ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_SetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxReadOnlyDC_SetLayoutDirection, "SetLayoutDirection(dir) -> None\n"
"\n"
"Sets the current layout direction for the device context.");

extern "C" {static PyObject *meth_wxReadOnlyDC_SetLayoutDirection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxReadOnlyDC_SetLayoutDirection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxLayoutDirection dir;
        ::wxReadOnlyDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxReadOnlyDC, &sipCpp, sipType_wxLayoutDirection, &dir))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLayoutDirection(dir);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ReadOnlyDC, sipName_SetLayoutDirection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxReadOnlyDC(void *, const sipTypeDef *);}
static void *cast_wxReadOnlyDC(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxReadOnlyDC *sipCpp = reinterpret_cast< ::wxReadOnlyDC *>(sipCppV);

    if (targetType == sipType_wxReadOnlyDC)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxReadOnlyDC(void *, int);}
static void release_wxReadOnlyDC(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxReadOnlyDC *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxReadOnlyDC(sipSimpleWrapper *);}
static void dealloc_wxReadOnlyDC(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxReadOnlyDC(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxReadOnlyDC[] = {{398, 255, 1}};


static PyMethodDef methods_wxReadOnlyDC[] = {
    {sipName_CanDrawBitmap, meth_wxReadOnlyDC_CanDrawBitmap, METH_VARARGS, doc_wxReadOnlyDC_CanDrawBitmap},
    {sipName_CanGetTextExtent, meth_wxReadOnlyDC_CanGetTextExtent, METH_VARARGS, doc_wxReadOnlyDC_CanGetTextExtent},
    {sipName_CanUseTransformMatrix, meth_wxReadOnlyDC_CanUseTransformMatrix, METH_VARARGS, doc_wxReadOnlyDC_CanUseTransformMatrix},
    {sipName_DeviceToLogical, SIP_MLMETH_CAST(meth_wxReadOnlyDC_DeviceToLogical), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_DeviceToLogical},
    {sipName_DeviceToLogicalRel, SIP_MLMETH_CAST(meth_wxReadOnlyDC_DeviceToLogicalRel), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_DeviceToLogicalRel},
    {sipName_DeviceToLogicalX, SIP_MLMETH_CAST(meth_wxReadOnlyDC_DeviceToLogicalX), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_DeviceToLogicalX},
    {sipName_DeviceToLogicalXRel, SIP_MLMETH_CAST(meth_wxReadOnlyDC_DeviceToLogicalXRel), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_DeviceToLogicalXRel},
    {sipName_DeviceToLogicalY, SIP_MLMETH_CAST(meth_wxReadOnlyDC_DeviceToLogicalY), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_DeviceToLogicalY},
    {sipName_DeviceToLogicalYRel, SIP_MLMETH_CAST(meth_wxReadOnlyDC_DeviceToLogicalYRel), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_DeviceToLogicalYRel},
    {sipName_FromDIP, SIP_MLMETH_CAST(meth_wxReadOnlyDC_FromDIP), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_FromDIP},
    {sipName_GetCharHeight, meth_wxReadOnlyDC_GetCharHeight, METH_VARARGS, doc_wxReadOnlyDC_GetCharHeight},
    {sipName_GetCharWidth, meth_wxReadOnlyDC_GetCharWidth, METH_VARARGS, doc_wxReadOnlyDC_GetCharWidth},
    {sipName_GetContentScaleFactor, meth_wxReadOnlyDC_GetContentScaleFactor, METH_VARARGS, doc_wxReadOnlyDC_GetContentScaleFactor},
    {sipName_GetDepth, meth_wxReadOnlyDC_GetDepth, METH_VARARGS, doc_wxReadOnlyDC_GetDepth},
    {sipName_GetDeviceOrigin, meth_wxReadOnlyDC_GetDeviceOrigin, METH_VARARGS, doc_wxReadOnlyDC_GetDeviceOrigin},
    {sipName_GetFont, meth_wxReadOnlyDC_GetFont, METH_VARARGS, doc_wxReadOnlyDC_GetFont},
    {sipName_GetFontMetrics, meth_wxReadOnlyDC_GetFontMetrics, METH_VARARGS, doc_wxReadOnlyDC_GetFontMetrics},
    {sipName_GetFullMultiLineTextExtent, SIP_MLMETH_CAST(meth_wxReadOnlyDC_GetFullMultiLineTextExtent), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_GetFullMultiLineTextExtent},
    {sipName_GetFullTextExtent, SIP_MLMETH_CAST(meth_wxReadOnlyDC_GetFullTextExtent), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_GetFullTextExtent},
    {sipName_GetLayoutDirection, meth_wxReadOnlyDC_GetLayoutDirection, METH_VARARGS, doc_wxReadOnlyDC_GetLayoutDirection},
    {sipName_GetLogicalOrigin, SIP_MLMETH_CAST(meth_wxReadOnlyDC_GetLogicalOrigin), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_GetLogicalOrigin},
    {sipName_GetLogicalScale, SIP_MLMETH_CAST(meth_wxReadOnlyDC_GetLogicalScale), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_GetLogicalScale},
    {sipName_GetMapMode, meth_wxReadOnlyDC_GetMapMode, METH_VARARGS, doc_wxReadOnlyDC_GetMapMode},
    {sipName_GetPPI, meth_wxReadOnlyDC_GetPPI, METH_VARARGS, doc_wxReadOnlyDC_GetPPI},
    {sipName_GetPartialTextExtents, SIP_MLMETH_CAST(meth_wxReadOnlyDC_GetPartialTextExtents), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_GetPartialTextExtents},
    {sipName_GetSize, meth_wxReadOnlyDC_GetSize, METH_VARARGS, doc_wxReadOnlyDC_GetSize},
    {sipName_GetSizeMM, meth_wxReadOnlyDC_GetSizeMM, METH_VARARGS, doc_wxReadOnlyDC_GetSizeMM},
    {sipName_GetTransformMatrix, meth_wxReadOnlyDC_GetTransformMatrix, METH_VARARGS, doc_wxReadOnlyDC_GetTransformMatrix},
    {sipName_GetUserScale, SIP_MLMETH_CAST(meth_wxReadOnlyDC_GetUserScale), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_GetUserScale},
    {sipName_IsOk, meth_wxReadOnlyDC_IsOk, METH_VARARGS, doc_wxReadOnlyDC_IsOk},
    {sipName_LogicalToDevice, SIP_MLMETH_CAST(meth_wxReadOnlyDC_LogicalToDevice), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_LogicalToDevice},
    {sipName_LogicalToDeviceRel, SIP_MLMETH_CAST(meth_wxReadOnlyDC_LogicalToDeviceRel), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_LogicalToDeviceRel},
    {sipName_LogicalToDeviceX, SIP_MLMETH_CAST(meth_wxReadOnlyDC_LogicalToDeviceX), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_LogicalToDeviceX},
    {sipName_LogicalToDeviceXRel, SIP_MLMETH_CAST(meth_wxReadOnlyDC_LogicalToDeviceXRel), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_LogicalToDeviceXRel},
    {sipName_LogicalToDeviceY, SIP_MLMETH_CAST(meth_wxReadOnlyDC_LogicalToDeviceY), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_LogicalToDeviceY},
    {sipName_LogicalToDeviceYRel, SIP_MLMETH_CAST(meth_wxReadOnlyDC_LogicalToDeviceYRel), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_LogicalToDeviceYRel},
    {sipName_ResetTransformMatrix, meth_wxReadOnlyDC_ResetTransformMatrix, METH_VARARGS, doc_wxReadOnlyDC_ResetTransformMatrix},
    {sipName_SetAxisOrientation, SIP_MLMETH_CAST(meth_wxReadOnlyDC_SetAxisOrientation), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_SetAxisOrientation},
    {sipName_SetDeviceOrigin, SIP_MLMETH_CAST(meth_wxReadOnlyDC_SetDeviceOrigin), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_SetDeviceOrigin},
    {sipName_SetFont, SIP_MLMETH_CAST(meth_wxReadOnlyDC_SetFont), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_SetFont},
    {sipName_SetLayoutDirection, SIP_MLMETH_CAST(meth_wxReadOnlyDC_SetLayoutDirection), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_SetLayoutDirection},
    {sipName_SetLogicalOrigin, SIP_MLMETH_CAST(meth_wxReadOnlyDC_SetLogicalOrigin), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_SetLogicalOrigin},
    {sipName_SetLogicalScale, SIP_MLMETH_CAST(meth_wxReadOnlyDC_SetLogicalScale), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_SetLogicalScale},
    {sipName_SetMapMode, SIP_MLMETH_CAST(meth_wxReadOnlyDC_SetMapMode), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_SetMapMode},
    {sipName_SetTransformMatrix, SIP_MLMETH_CAST(meth_wxReadOnlyDC_SetTransformMatrix), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_SetTransformMatrix},
    {sipName_SetUserScale, SIP_MLMETH_CAST(meth_wxReadOnlyDC_SetUserScale), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_SetUserScale},
    {sipName_ToDIP, SIP_MLMETH_CAST(meth_wxReadOnlyDC_ToDIP), METH_VARARGS|METH_KEYWORDS, doc_wxReadOnlyDC_ToDIP}
};

sipVariableDef variables_wxReadOnlyDC[] = {
    {PropertyVariable, sipName_TransformMatrix, &methods_wxReadOnlyDC[27], &methods_wxReadOnlyDC[44], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_SizeMM, &methods_wxReadOnlyDC[26], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Size, &methods_wxReadOnlyDC[25], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PPI, &methods_wxReadOnlyDC[23], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MapMode, &methods_wxReadOnlyDC[22], &methods_wxReadOnlyDC[43], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LayoutDirection, &methods_wxReadOnlyDC[19], &methods_wxReadOnlyDC[40], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FontMetrics, &methods_wxReadOnlyDC[16], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Font, &methods_wxReadOnlyDC[15], &methods_wxReadOnlyDC[39], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DeviceOrigin, &methods_wxReadOnlyDC[14], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Depth, &methods_wxReadOnlyDC[13], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ContentScaleFactor, &methods_wxReadOnlyDC[12], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_CharWidth, &methods_wxReadOnlyDC[11], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_CharHeight, &methods_wxReadOnlyDC[10], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxReadOnlyDC, "Base class for device context not providing any drawing functions.");


sipClassTypeDef sipTypeDef__core_wxReadOnlyDC = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxReadOnlyDC,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_ReadOnlyDC,
        {0, 0, 1},
        47, methods_wxReadOnlyDC,
        0, SIP_NULLPTR,
        13, variables_wxReadOnlyDC,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxReadOnlyDC,
    -1,
    -1,
    supers_wxReadOnlyDC,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxReadOnlyDC,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxReadOnlyDC,
    cast_wxReadOnlyDC,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
