/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
    #include <wx/longlong.h>



extern "C" {static void assign_wxLongLong(void *, Py_ssize_t, void *);}
static void assign_wxLongLong(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxLongLong *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxLongLong *>(sipSrc);
}


extern "C" {static void *array_wxLongLong(Py_ssize_t);}
static void *array_wxLongLong(Py_ssize_t sipNrElem)
{
    return new ::wxLongLong[sipNrElem];
}


extern "C" {static void *copy_wxLongLong(const void *, Py_ssize_t);}
static void *copy_wxLongLong(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxLongLong(reinterpret_cast<const ::wxLongLong *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_wxLongLong(void *, int);}
static void release_wxLongLong(void *sipCppV, int)
{
    ::wxLongLong *sipCpp = reinterpret_cast< ::wxLongLong *>(sipCppV);
    Py_BEGIN_ALLOW_THREADS
    delete sipCpp;
    Py_END_ALLOW_THREADS
}



extern "C" {static int convertTo_wxLongLong(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxLongLong(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::wxLongLong **sipCppPtr = reinterpret_cast< ::wxLongLong **>(sipCppPtrV);
        // Code to test a PyObject for compatibility
        if (!sipIsErr) {
            if (PyNumber_Check(sipPy))
                return TRUE;
            return FALSE;
        }

        // Code to convert from a compatible PyObject
        #if wxUSE_LONGLONG_NATIVE
            *sipCppPtr = new wxLongLong(PyLong_AsLongLong(sipPy));
        #else
            #error TODO. Get the hi/lo 32-bit dwords to construct the wxLongLong
        #endif
        return sipGetState(sipTransferObj);
}


extern "C" {static PyObject *convertFrom_wxLongLong(void *, PyObject *);}
static PyObject *convertFrom_wxLongLong(void *sipCppV, PyObject *)
{
    ::wxLongLong *sipCpp = reinterpret_cast< ::wxLongLong *>(sipCppV);
        #if wxUSE_LONGLONG_NATIVE
            return PyLong_FromLongLong(sipCpp->GetValue());
        #else
            #error This is untested
            // Convert a wxLongLong to a Python Long by getting the hi/lo
            // dwords, then shifting and or-ing them together
            PyObject *hi, *lo, *shifter, *shifted, *result;
            hi = PyLong_FromLong( sipCpp->GetHi() );
            lo = PyLong_FromLong( sipCpp->GetLo() );
            shifter = PyLong_FromLong(32);
            shifted = PyNumber_Lshift(hi, shifter);
            result = PyNumber_Or(shifted, lo);
            Py_DECREF(hi);
            Py_DECREF(lo);
            Py_DECREF(shifter);
            Py_DECREF(shifted);
            return result;
        #endif
}


sipMappedTypeDef sipTypeDef__core_wxLongLong = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_wxLongLong,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_wxLongLong,
    array_wxLongLong,
    copy_wxLongLong,
    release_wxLongLong,
    convertTo_wxLongLong,
    convertFrom_wxLongLong
};
