/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/imaglist.h>
        #include <wx/bitmap.h>
        #include <wx/icon.h>
        #include <wx/gdicmn.h>
        #include <wx/dc.h>
        #include <wx/colour.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxImageList_Add, "Add(bitmap, mask=NullBitmap) -> int\n"
"Add(bitmap, maskColour) -> int\n"
"Add(icon) -> int\n"
"\n"
"Adds a new image or images using a bitmap and optional mask bitmap.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxImageList_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBitmap* bitmap;
        const ::wxBitmap& maskdef = wxNullBitmap;
        const ::wxBitmap* mask = &maskdef;
        ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
            sipName_mask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J9", &sipSelf, sipType_wxImageList, &sipCpp, sipType_wxBitmap, &bitmap, sipType_wxBitmap, &mask))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(*bitmap, *mask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    {
        const ::wxBitmap* bitmap;
        const ::wxColour* maskColour;
        int maskColourState = 0;
        ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
            sipName_maskColour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1", &sipSelf, sipType_wxImageList, &sipCpp, sipType_wxBitmap, &bitmap, sipType_wxColour, &maskColour, &maskColourState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(*bitmap, *maskColour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(maskColour), sipType_wxColour, maskColourState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    {
        const ::wxIcon* icon;
        ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxImageList, &sipCpp, sipType_wxIcon, &icon))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Add, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_Create, "Create(width, height, mask=True, initialCount=1) -> bool\n"
"\n"
"Initializes the list.");

extern "C" {static PyObject *meth_wxImageList_Create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Create(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
        int height;
        bool mask = 1;
        int initialCount = 1;
        ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_mask,
            sipName_initialCount,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|bi", &sipSelf, sipType_wxImageList, &sipCpp, &width, &height, &mask, &initialCount))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Create(width, height, mask, initialCount);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Create, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_Destroy, "Destroy() -> None\n"
"\n"
"Destroys the current list.");

extern "C" {static PyObject *meth_wxImageList_Destroy(PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Destroy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxImageList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageList, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Destroy();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Destroy, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_Draw, "Draw(index, dc, x, y, flags=IMAGELIST_DRAW_NORMAL, solidBackground=False) -> bool\n"
"\n"
"Draws a specified image onto a device context.");

extern "C" {static PyObject *meth_wxImageList_Draw(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Draw(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int index;
        ::wxDC* dc;
        int x;
        int y;
        int flags = wxIMAGELIST_DRAW_NORMAL;
        bool solidBackground = 0;
        ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_dc,
            sipName_x,
            sipName_y,
            sipName_flags,
            sipName_solidBackground,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiJ9ii|ib", &sipSelf, sipType_wxImageList, &sipCpp, &index, sipType_wxDC, &dc, &x, &y, &flags, &solidBackground))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Draw(index, *dc, x, y, flags, solidBackground);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Draw, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_GetBitmap, "GetBitmap(index) -> Bitmap\n"
"\n"
"Returns the bitmap corresponding to the given index.");

extern "C" {static PyObject *meth_wxImageList_GetBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_GetBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int index;
        const ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxImageList, &sipCpp, &index))
        {
            ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmap(sipCpp->GetBitmap(index));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_GetBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_GetIcon, "GetIcon(index) -> Icon\n"
"\n"
"Returns the icon corresponding to the given index.");

extern "C" {static PyObject *meth_wxImageList_GetIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_GetIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int index;
        const ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxImageList, &sipCpp, &index))
        {
            ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxIcon(sipCpp->GetIcon(index));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxIcon, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_GetIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_GetImageCount, "GetImageCount() -> int\n"
"\n"
"Returns the number of images in the list.");

extern "C" {static PyObject *meth_wxImageList_GetImageCount(PyObject *, PyObject *);}
static PyObject *meth_wxImageList_GetImageCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxImageList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageList, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetImageCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_GetImageCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_GetSize, "GetSize(index) -> Tuple[int, int]\n"
"GetSize() -> Size\n"
"\n"
"Retrieves the size of the images in the list.\n"
"");

extern "C" {static PyObject *meth_wxImageList_GetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_GetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int index;
        int width;
        int height;
        const ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxImageList, &sipCpp, &index))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetSize(index, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(ii)", width, height);
        }
    }

    {
        const ::wxImageList *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxImageList, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_GetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_Remove, "Remove(index) -> bool\n"
"\n"
"Removes the image at the given position.");

extern "C" {static PyObject *meth_wxImageList_Remove(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Remove(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int index;
        ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxImageList, &sipCpp, &index))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Remove(index);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Remove, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_RemoveAll, "RemoveAll() -> bool\n"
"\n"
"Removes all the images in the list.");

extern "C" {static PyObject *meth_wxImageList_RemoveAll(PyObject *, PyObject *);}
static PyObject *meth_wxImageList_RemoveAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxImageList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageList, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveAll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_RemoveAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageList_Replace, "Replace(index, bitmap, mask=NullBitmap) -> bool\n"
"Replace(index, icon) -> bool\n"
"\n"
"Replaces the existing image with the new image.\n"
"");

extern "C" {static PyObject *meth_wxImageList_Replace(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Replace(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int index;
        const ::wxBitmap* bitmap;
        const ::wxBitmap& maskdef = wxNullBitmap;
        const ::wxBitmap* mask = &maskdef;
        ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_bitmap,
            sipName_mask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiJ9|J9", &sipSelf, sipType_wxImageList, &sipCpp, &index, sipType_wxBitmap, &bitmap, sipType_wxBitmap, &mask))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Replace(index, *bitmap, *mask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int index;
        const ::wxIcon* icon;
        ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiJ9", &sipSelf, sipType_wxImageList, &sipCpp, &index, sipType_wxIcon, &icon))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Replace(index, *icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Replace, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxImageList(void *, const sipTypeDef *);}
static void *cast_wxImageList(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxImageList *sipCpp = reinterpret_cast< ::wxImageList *>(sipCppV);

    if (targetType == sipType_wxImageList)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxImageList(void *, int);}
static void release_wxImageList(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxImageList *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxImageList(sipSimpleWrapper *);}
static void dealloc_wxImageList(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxImageList(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxImageList(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxImageList(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxImageList *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxImageList();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        int width;
        int height;
        bool mask = 1;
        int initialCount = 1;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_mask,
            sipName_initialCount,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii|bi", &width, &height, &mask, &initialCount))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxImageList(width, height, mask, initialCount);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxImageList[] = {{398, 255, 1}};


static PyMethodDef methods_wxImageList[] = {
    {sipName_Add, SIP_MLMETH_CAST(meth_wxImageList_Add), METH_VARARGS|METH_KEYWORDS, doc_wxImageList_Add},
    {sipName_Create, SIP_MLMETH_CAST(meth_wxImageList_Create), METH_VARARGS|METH_KEYWORDS, doc_wxImageList_Create},
    {sipName_Destroy, meth_wxImageList_Destroy, METH_VARARGS, doc_wxImageList_Destroy},
    {sipName_Draw, SIP_MLMETH_CAST(meth_wxImageList_Draw), METH_VARARGS|METH_KEYWORDS, doc_wxImageList_Draw},
    {sipName_GetBitmap, SIP_MLMETH_CAST(meth_wxImageList_GetBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxImageList_GetBitmap},
    {sipName_GetIcon, SIP_MLMETH_CAST(meth_wxImageList_GetIcon), METH_VARARGS|METH_KEYWORDS, doc_wxImageList_GetIcon},
    {sipName_GetImageCount, meth_wxImageList_GetImageCount, METH_VARARGS, doc_wxImageList_GetImageCount},
    {sipName_GetSize, SIP_MLMETH_CAST(meth_wxImageList_GetSize), METH_VARARGS|METH_KEYWORDS, doc_wxImageList_GetSize},
    {sipName_Remove, SIP_MLMETH_CAST(meth_wxImageList_Remove), METH_VARARGS|METH_KEYWORDS, doc_wxImageList_Remove},
    {sipName_RemoveAll, meth_wxImageList_RemoveAll, METH_VARARGS, doc_wxImageList_RemoveAll},
    {sipName_Replace, SIP_MLMETH_CAST(meth_wxImageList_Replace), METH_VARARGS|METH_KEYWORDS, doc_wxImageList_Replace}
};

sipVariableDef variables_wxImageList[] = {
    {PropertyVariable, sipName_Size, &methods_wxImageList[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ImageCount, &methods_wxImageList[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxImageList, "ImageList() -> None\n"
"ImageList(width, height, mask=True, initialCount=1) -> None\n"
"\n"
"A wxImageList contains a list of images, which are stored in an\n"
"unspecified form.");


sipClassTypeDef sipTypeDef__core_wxImageList = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxImageList,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_ImageList,
        {0, 0, 1},
        11, methods_wxImageList,
        0, SIP_NULLPTR,
        2, variables_wxImageList,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxImageList,
    -1,
    -1,
    supers_wxImageList,
    SIP_NULLPTR,
    init_type_wxImageList,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxImageList,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxImageList,
    cast_wxImageList,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxImageList),
};
