/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/gbsizer.h>
        #include <wx/gdicmn.h>
        #include <wx/gbsizer.h>
        #include <wx/object.h>
        #include <wx/gbsizer.h>
        #include <wx/gdicmn.h>
        #include <wx/window.h>
        #include <wx/gbsizer.h>
        #include <wx/sizer.h>
        #include <wx/sizer.h>
        #include <wx/sizer.h>
        #include <wx/object.h>
        #include <wx/object.h>
    wxSizerItem* _wxGridBagSizer_Add(wxGridBagSizer* self, const wxSize* size, const wxGBPosition* pos, const wxGBSpan* span, int flag, int border, wxObject* userData )
    {
        return self->Add(size->x, size->y, *pos, *span, flag, border, userData);
    }


class sipwxGridBagSizer : public ::wxGridBagSizer
{
public:
    sipwxGridBagSizer(int, int);
    virtual ~sipwxGridBagSizer();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxSize CalcMin() SIP_OVERRIDE;
    bool InformFirstDirection(int, int, int) SIP_OVERRIDE;
    void RepositionChildren(const ::wxSize&) SIP_OVERRIDE;
    void RecalcSizes() SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxGridBagSizer(const sipwxGridBagSizer &);
    sipwxGridBagSizer &operator = (const sipwxGridBagSizer &);

    char sipPyMethods[4];
};

sipwxGridBagSizer::sipwxGridBagSizer(int vgap, int hgap): ::wxGridBagSizer(vgap, hgap), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxGridBagSizer::~sipwxGridBagSizer()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxSize sipwxGridBagSizer::CalcMin()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_CalcMin);

    if (!sipMeth)
        return ::wxGridBagSizer::CalcMin();

    extern ::wxSize sipVH__core_25(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_25(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxGridBagSizer::InformFirstDirection(int direction, int size, int availableOtherDir)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_InformFirstDirection);

    if (!sipMeth)
        return ::wxGridBagSizer::InformFirstDirection(direction, size, availableOtherDir);

    extern bool sipVH__core_104(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int, int, int);

    return sipVH__core_104(sipGILState, 0, sipPySelf, sipMeth, direction, size, availableOtherDir);
}

void sipwxGridBagSizer::RepositionChildren(const ::wxSize& minSize)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_RepositionChildren);

    if (!sipMeth)
    {
        ::wxGridBagSizer::RepositionChildren(minSize);
        return;
    }

    extern void sipVH__core_105(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxSize&);

    sipVH__core_105(sipGILState, 0, sipPySelf, sipMeth, minSize);
}

void sipwxGridBagSizer::RecalcSizes()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_RecalcSizes);

    if (!sipMeth)
    {
        ::wxGridBagSizer::RecalcSizes();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxGridBagSizer_Add, "Add(window, pos, span=DefaultSpan, flag=0, border=0, userData=nullptr) -> SizerItem\n"
"Add(sizer, pos, span=DefaultSpan, flag=0, border=0, userData=nullptr) -> SizerItem\n"
"Add(item) -> SizerItem\n"
"Add(width, height, pos, span=DefaultSpan, flag=0, border=0, userData=nullptr) -> SizerItem\n"
"Add(size, pos, span=DefaultSpan, flag=0, border=0, Transfer=None) -> SizerItem\n"
"\n"
"Adds the given item to the given position.\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxGridBagSizer_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* window;
        const ::wxGBPosition* pos;
        int posState = 0;
        const ::wxGBSpan& spandef = wxDefaultSpan;
        const ::wxGBSpan* span = &spandef;
        int spanState = 0;
        int flag = 0;
        int border = 0;
        ::wxPyUserData* userData = nullptr;
        int userDataState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
            sipName_pos,
            sipName_span,
            sipName_flag,
            sipName_border,
            sipName_userData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1|J1iiJ2", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxWindow, &window, sipType_wxGBPosition, &pos, &posState, sipType_wxGBSpan, &span, &spanState, &flag, &border, sipType_wxPyUserData, &userData, &userDataState))
        {
            ::wxSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(window, *pos, *span, flag, border, userData);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBPosition *>(pos), sipType_wxGBPosition, posState);
            sipReleaseType(const_cast< ::wxGBSpan *>(span), sipType_wxGBSpan, spanState);
            sipReleaseType(userData, sipType_wxPyUserData, userDataState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxSizerItem, SIP_NULLPTR);
        }
    }

    {
        ::wxSizer* sizer;
        const ::wxGBPosition* pos;
        int posState = 0;
        const ::wxGBSpan& spandef = wxDefaultSpan;
        const ::wxGBSpan* span = &spandef;
        int spanState = 0;
        int flag = 0;
        int border = 0;
        ::wxPyUserData* userData = nullptr;
        int userDataState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sizer,
            sipName_pos,
            sipName_span,
            sipName_flag,
            sipName_border,
            sipName_userData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:J1|J1iiJ2", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxSizer, &sizer, sipType_wxGBPosition, &pos, &posState, sipType_wxGBSpan, &span, &spanState, &flag, &border, sipType_wxPyUserData, &userData, &userDataState))
        {
            ::wxSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(sizer, *pos, *span, flag, border, userData);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBPosition *>(pos), sipType_wxGBPosition, posState);
            sipReleaseType(const_cast< ::wxGBSpan *>(span), sipType_wxGBSpan, spanState);
            sipReleaseType(userData, sipType_wxPyUserData, userDataState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxSizerItem, SIP_NULLPTR);
        }
    }

    {
        ::wxGBSizerItem* item;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxGBSizerItem, &item))
        {
            ::wxSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(item);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxSizerItem, SIP_NULLPTR);
        }
    }

    {
        int width;
        int height;
        const ::wxGBPosition* pos;
        int posState = 0;
        const ::wxGBSpan& spandef = wxDefaultSpan;
        const ::wxGBSpan* span = &spandef;
        int spanState = 0;
        int flag = 0;
        int border = 0;
        ::wxPyUserData* userData = nullptr;
        int userDataState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_pos,
            sipName_span,
            sipName_flag,
            sipName_border,
            sipName_userData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiiJ1|J1iiJ2", &sipSelf, sipType_wxGridBagSizer, &sipCpp, &width, &height, sipType_wxGBPosition, &pos, &posState, sipType_wxGBSpan, &span, &spanState, &flag, &border, sipType_wxPyUserData, &userData, &userDataState))
        {
            ::wxSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(width, height, *pos, *span, flag, border, userData);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBPosition *>(pos), sipType_wxGBPosition, posState);
            sipReleaseType(const_cast< ::wxGBSpan *>(span), sipType_wxGBSpan, spanState);
            sipReleaseType(userData, sipType_wxPyUserData, userDataState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxSizerItem, SIP_NULLPTR);
        }
    }

    {
        const ::wxSize* size;
        int sizeState = 0;
        const ::wxGBPosition* pos;
        int posState = 0;
        const ::wxGBSpan& spandef = wxDefaultSpan;
        const ::wxGBSpan* span = &spandef;
        int spanState = 0;
        int flag = 0;
        int border = 0;
        ::wxObject* userData = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_pos,
            sipName_span,
            sipName_flag,
            sipName_border,
            sipName_userData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|J1iiJ:", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxSize, &size, &sizeState, sipType_wxGBPosition, &pos, &posState, sipType_wxGBSpan, &span, &spanState, &flag, &border, sipType_wxObject, &userData))
        {
            ::wxSizerItem*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxGridBagSizer_Add(sipCpp, size, pos, span, flag, border, userData);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxSize *>(size), sipType_wxSize, sizeState);
            sipReleaseType(const_cast< ::wxGBPosition *>(pos), sipType_wxGBPosition, posState);
            sipReleaseType(const_cast< ::wxGBSpan *>(span), sipType_wxGBSpan, spanState);

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes, sipType_wxSizerItem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_Add, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_CheckForIntersection, "CheckForIntersection(item, excludeItem=nullptr) -> bool\n"
"CheckForIntersection(pos, span, excludeItem=nullptr) -> bool\n"
"\n"
"Look at all items and see if any intersect (or would overlap) the\n"
"given item.\n"
"");

extern "C" {static PyObject *meth_wxGridBagSizer_CheckForIntersection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_CheckForIntersection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGBSizerItem* item;
        ::wxGBSizerItem* excludeItem = nullptr;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_excludeItem,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8|J8", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxGBSizerItem, &item, sipType_wxGBSizerItem, &excludeItem))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CheckForIntersection(item, excludeItem);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxGBPosition* pos;
        int posState = 0;
        const ::wxGBSpan* span;
        int spanState = 0;
        ::wxGBSizerItem* excludeItem = nullptr;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
            sipName_span,
            sipName_excludeItem,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|J8", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxGBPosition, &pos, &posState, sipType_wxGBSpan, &span, &spanState, sipType_wxGBSizerItem, &excludeItem))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CheckForIntersection(*pos, *span, excludeItem);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBPosition *>(pos), sipType_wxGBPosition, posState);
            sipReleaseType(const_cast< ::wxGBSpan *>(span), sipType_wxGBSpan, spanState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_CheckForIntersection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_FindItem, "FindItem(window) -> GBSizerItem\n"
"FindItem(sizer) -> GBSizerItem\n"
"\n"
"Find the sizer item for the given window or subsizer, returns nullptr\n"
"if not found.\n"
"");

extern "C" {static PyObject *meth_wxGridBagSizer_FindItem(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_FindItem(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* window;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxWindow, &window))
        {
            ::wxGBSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindItem(window);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGBSizerItem, SIP_NULLPTR);
        }
    }

    {
        ::wxSizer* sizer;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sizer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxSizer, &sizer))
        {
            ::wxGBSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindItem(sizer);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGBSizerItem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_FindItem, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_GetItemPosition, "GetItemPosition(window) -> GBPosition\n"
"GetItemPosition(sizer) -> GBPosition\n"
"GetItemPosition(index) -> GBPosition\n"
"\n"
"Get the grid position of the specified item.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxGridBagSizer_GetItemPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_GetItemPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* window;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxWindow, &window))
        {
            ::wxGBPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGBPosition(sipCpp->GetItemPosition(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGBPosition, SIP_NULLPTR);
        }
    }

    {
        ::wxSizer* sizer;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sizer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxSizer, &sizer))
        {
            ::wxGBPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGBPosition(sipCpp->GetItemPosition(sizer));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGBPosition, SIP_NULLPTR);
        }
    }

    {
        size_t index;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxGridBagSizer, &sipCpp, &index))
        {
            ::wxGBPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGBPosition(sipCpp->GetItemPosition(index));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGBPosition, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_GetItemPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_GetItemSpan, "GetItemSpan(window) -> GBSpan\n"
"GetItemSpan(sizer) -> GBSpan\n"
"GetItemSpan(index) -> GBSpan\n"
"\n"
"Get the row/col spanning of the specified item.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxGridBagSizer_GetItemSpan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_GetItemSpan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* window;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxWindow, &window))
        {
            ::wxGBSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGBSpan(sipCpp->GetItemSpan(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGBSpan, SIP_NULLPTR);
        }
    }

    {
        ::wxSizer* sizer;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sizer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxSizer, &sizer))
        {
            ::wxGBSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGBSpan(sipCpp->GetItemSpan(sizer));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGBSpan, SIP_NULLPTR);
        }
    }

    {
        size_t index;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxGridBagSizer, &sipCpp, &index))
        {
            ::wxGBSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGBSpan(sipCpp->GetItemSpan(index));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGBSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_GetItemSpan, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_SetItemPosition, "SetItemPosition(window, pos) -> bool\n"
"SetItemPosition(sizer, pos) -> bool\n"
"SetItemPosition(index, pos) -> bool\n"
"\n"
"Set the grid position of the specified item.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxGridBagSizer_SetItemPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_SetItemPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* window;
        const ::wxGBPosition* pos;
        int posState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxWindow, &window, sipType_wxGBPosition, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetItemPosition(window, *pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBPosition *>(pos), sipType_wxGBPosition, posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        ::wxSizer* sizer;
        const ::wxGBPosition* pos;
        int posState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sizer,
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxSizer, &sizer, sipType_wxGBPosition, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetItemPosition(sizer, *pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBPosition *>(pos), sipType_wxGBPosition, posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        size_t index;
        const ::wxGBPosition* pos;
        int posState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=J1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, &index, sipType_wxGBPosition, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetItemPosition(index, *pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBPosition *>(pos), sipType_wxGBPosition, posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_SetItemPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_SetItemSpan, "SetItemSpan(window, span) -> bool\n"
"SetItemSpan(sizer, span) -> bool\n"
"SetItemSpan(index, span) -> bool\n"
"\n"
"Set the row/col spanning of the specified item.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxGridBagSizer_SetItemSpan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_SetItemSpan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* window;
        const ::wxGBSpan* span;
        int spanState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
            sipName_span,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxWindow, &window, sipType_wxGBSpan, &span, &spanState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetItemSpan(window, *span);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBSpan *>(span), sipType_wxGBSpan, spanState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        ::wxSizer* sizer;
        const ::wxGBSpan* span;
        int spanState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sizer,
            sipName_span,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxSizer, &sizer, sipType_wxGBSpan, &span, &spanState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetItemSpan(sizer, *span);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBSpan *>(span), sipType_wxGBSpan, spanState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        size_t index;
        const ::wxGBSpan* span;
        int spanState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_span,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=J1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, &index, sipType_wxGBSpan, &span, &spanState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetItemSpan(index, *span);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBSpan *>(span), sipType_wxGBSpan, spanState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_SetItemSpan, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_CalcMin, "CalcMin() -> Size\n"
"\n"
"Called when the managed size of the sizer is needed or when layout\n"
"needs done.");

extern "C" {static PyObject *meth_wxGridBagSizer_CalcMin(PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_CalcMin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxGridBagSizer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBagSizer, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize((sipSelfWasArg ? sipCpp->::wxGridBagSizer::CalcMin() : sipCpp->CalcMin()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_CalcMin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_FindItemAtPoint, "FindItemAtPoint(pt) -> GBSizerItem\n"
"\n"
"Return the sizer item located at the point given in pt, or nullptr if\n"
"there is no item at that point.");

extern "C" {static PyObject *meth_wxGridBagSizer_FindItemAtPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_FindItemAtPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            ::wxGBSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindItemAtPoint(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGBSizerItem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_FindItemAtPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_FindItemAtPosition, "FindItemAtPosition(pos) -> GBSizerItem\n"
"\n"
"Return the sizer item for the given grid cell, or nullptr if there is\n"
"no item at that position.");

extern "C" {static PyObject *meth_wxGridBagSizer_FindItemAtPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_FindItemAtPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGBPosition* pos;
        int posState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxGBPosition, &pos, &posState))
        {
            ::wxGBSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindItemAtPosition(*pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBPosition *>(pos), sipType_wxGBPosition, posState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGBSizerItem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_FindItemAtPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_FindItemWithData, "FindItemWithData(userData) -> GBSizerItem\n"
"\n"
"Return the sizer item that has a matching user data (it only compares\n"
"pointer values) or nullptr if not found.");

extern "C" {static PyObject *meth_wxGridBagSizer_FindItemWithData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_FindItemWithData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxObject* userData;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_userData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxObject, &userData))
        {
            ::wxGBSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindItemWithData(userData);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGBSizerItem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_FindItemWithData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_GetCellSize, "GetCellSize(row, col) -> Size\n"
"\n"
"Get the size of the specified cell, including hgap and vgap.");

extern "C" {static PyObject *meth_wxGridBagSizer_GetCellSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_GetCellSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int row;
        int col;
        const ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxGridBagSizer, &sipCpp, &row, &col))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetCellSize(row, col));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_GetCellSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_GetEmptyCellSize, "GetEmptyCellSize() -> Size\n"
"\n"
"Get the size used for cells in the grid with no item.");

extern "C" {static PyObject *meth_wxGridBagSizer_GetEmptyCellSize(PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_GetEmptyCellSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBagSizer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBagSizer, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetEmptyCellSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_GetEmptyCellSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_RepositionChildren, "RepositionChildren(minSize) -> None\n"
"\n"
"Called when the managed size of the sizer is needed or when layout\n"
"needs done.");

extern "C" {static PyObject *meth_wxGridBagSizer_RepositionChildren(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_RepositionChildren(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxSize* minSize;
        int minSizeState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_minSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxSize, &minSize, &minSizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxGridBagSizer::RepositionChildren(*minSize) : sipCpp->RepositionChildren(*minSize));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(minSize), sipType_wxSize, minSizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_RepositionChildren, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBagSizer_SetEmptyCellSize, "SetEmptyCellSize(sz) -> None\n"
"\n"
"Set the size used for cells in the grid with no item.");

extern "C" {static PyObject *meth_wxGridBagSizer_SetEmptyCellSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBagSizer_SetEmptyCellSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSize* sz;
        int szState = 0;
        ::wxGridBagSizer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxGridBagSizer, &sipCpp, sipType_wxSize, &sz, &szState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEmptyCellSize(*sz);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBagSizer, sipName_SetEmptyCellSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxGridBagSizer(void *, const sipTypeDef *);}
static void *cast_wxGridBagSizer(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxGridBagSizer *sipCpp = reinterpret_cast< ::wxGridBagSizer *>(sipCppV);

    if (targetType == sipType_wxGridBagSizer)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxFlexGridSizer)->ctd_cast(static_cast< ::wxFlexGridSizer *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGridBagSizer(void *, int);}
static void release_wxGridBagSizer(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxGridBagSizer *>(sipCppV);
    else
        delete reinterpret_cast< ::wxGridBagSizer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxGridBagSizer(sipSimpleWrapper *);}
static void dealloc_wxGridBagSizer(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxGridBagSizer *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGridBagSizer(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxGridBagSizer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGridBagSizer(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxGridBagSizer *sipCpp = SIP_NULLPTR;

    {
        int vgap = 0;
        int hgap = 0;

        static const char *sipKwdList[] = {
            sipName_vgap,
            sipName_hgap,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|ii", &vgap, &hgap))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxGridBagSizer(vgap, hgap);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxGridBagSizer[] = {{207, 255, 1}};


static PyMethodDef methods_wxGridBagSizer[] = {
    {sipName_Add, SIP_MLMETH_CAST(meth_wxGridBagSizer_Add), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_Add},
    {sipName_CalcMin, meth_wxGridBagSizer_CalcMin, METH_VARARGS, doc_wxGridBagSizer_CalcMin},
    {sipName_CheckForIntersection, SIP_MLMETH_CAST(meth_wxGridBagSizer_CheckForIntersection), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_CheckForIntersection},
    {sipName_FindItem, SIP_MLMETH_CAST(meth_wxGridBagSizer_FindItem), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_FindItem},
    {sipName_FindItemAtPoint, SIP_MLMETH_CAST(meth_wxGridBagSizer_FindItemAtPoint), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_FindItemAtPoint},
    {sipName_FindItemAtPosition, SIP_MLMETH_CAST(meth_wxGridBagSizer_FindItemAtPosition), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_FindItemAtPosition},
    {sipName_FindItemWithData, SIP_MLMETH_CAST(meth_wxGridBagSizer_FindItemWithData), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_FindItemWithData},
    {sipName_GetCellSize, SIP_MLMETH_CAST(meth_wxGridBagSizer_GetCellSize), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_GetCellSize},
    {sipName_GetEmptyCellSize, meth_wxGridBagSizer_GetEmptyCellSize, METH_VARARGS, doc_wxGridBagSizer_GetEmptyCellSize},
    {sipName_GetItemPosition, SIP_MLMETH_CAST(meth_wxGridBagSizer_GetItemPosition), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_GetItemPosition},
    {sipName_GetItemSpan, SIP_MLMETH_CAST(meth_wxGridBagSizer_GetItemSpan), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_GetItemSpan},
    {sipName_RepositionChildren, SIP_MLMETH_CAST(meth_wxGridBagSizer_RepositionChildren), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_RepositionChildren},
    {sipName_SetEmptyCellSize, SIP_MLMETH_CAST(meth_wxGridBagSizer_SetEmptyCellSize), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_SetEmptyCellSize},
    {sipName_SetItemPosition, SIP_MLMETH_CAST(meth_wxGridBagSizer_SetItemPosition), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_SetItemPosition},
    {sipName_SetItemSpan, SIP_MLMETH_CAST(meth_wxGridBagSizer_SetItemSpan), METH_VARARGS|METH_KEYWORDS, doc_wxGridBagSizer_SetItemSpan}
};

sipVariableDef variables_wxGridBagSizer[] = {
    {PropertyVariable, sipName_EmptyCellSize, &methods_wxGridBagSizer[8], &methods_wxGridBagSizer[12], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxGridBagSizer, "GridBagSizer(vgap=0, hgap=0) -> None\n"
"\n"
"A wxSizer that can lay out items in a virtual grid like a\n"
"wxFlexGridSizer but in this case explicit positioning of the items is\n"
"allowed using wxGBPosition, and items can optionally span more than\n"
"one row and/or column using wxGBSpan.");


sipClassTypeDef sipTypeDef__core_wxGridBagSizer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxGridBagSizer,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_GridBagSizer,
        {0, 0, 1},
        15, methods_wxGridBagSizer,
        0, SIP_NULLPTR,
        1, variables_wxGridBagSizer,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxGridBagSizer,
    -1,
    -1,
    supers_wxGridBagSizer,
    SIP_NULLPTR,
    init_type_wxGridBagSizer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxGridBagSizer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxGridBagSizer,
    cast_wxGridBagSizer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxGridBagSizer),
};
