/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/dnd.h>
        #include <wx/window.h>
        #include <wx/dataobj.h>
        #include <wx/icon.h>
        #include <wx/cursor.h>
    void _wxDropSource_SetCursor(wxDropSource* self, wxDragResult res, const wxCursorBundle *cursor)
    {
        #ifdef __WXGTK__
            wxPyRaiseNotImplementedMsg("Cursors not supported, use SetIcon on wxGTK instead.");
        #else
            self->SetCursor(res, *cursor);
        #endif
    }
    void _wxDropSource_SetIcon(wxDropSource* self, wxDragResult res, const wxIcon *icon)
    {
        #ifdef __WXGTK__
            self->SetIcon(res, *icon);
        #else
            wxPyRaiseNotImplementedMsg("Icons not supported, use SetCursor on non-wxGTK ports.");
        #endif
    }


class sipwxDropSource : public ::wxDropSource
{
public:
    sipwxDropSource(::wxWindow*);
    sipwxDropSource(::wxDataObject&, ::wxWindow*);
    virtual ~sipwxDropSource();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool GiveFeedback(::wxDragResult) SIP_OVERRIDE;
    ::wxDragResult DoDragDrop(int) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxDropSource(const sipwxDropSource &);
    sipwxDropSource &operator = (const sipwxDropSource &);

    char sipPyMethods[2];
};

sipwxDropSource::sipwxDropSource(::wxWindow*win): ::wxDropSource(win), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxDropSource::sipwxDropSource(::wxDataObject& data, ::wxWindow*win): ::wxDropSource(data, win), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxDropSource::~sipwxDropSource()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxDropSource::GiveFeedback(::wxDragResult effect)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_GiveFeedback);

    if (!sipMeth)
        return ::wxDropSource::GiveFeedback(effect);

    extern bool sipVH__core_87(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxDragResult);

    return sipVH__core_87(sipGILState, 0, sipPySelf, sipMeth, effect);
}

::wxDragResult sipwxDropSource::DoDragDrop(int flags)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_DoDragDrop);

    if (!sipMeth)
        return ::wxDropSource::DoDragDrop(flags);

    extern ::wxDragResult sipVH__core_86(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_86(sipGILState, 0, sipPySelf, sipMeth, flags);
}


PyDoc_STRVAR(doc_wxDropSource_DoDragDrop, "DoDragDrop(flags=Drag_CopyOnly) -> DragResult\n"
"\n"
"Starts the drag-and-drop operation which will terminate when the user\n"
"releases the mouse.");

extern "C" {static PyObject *meth_wxDropSource_DoDragDrop(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDropSource_DoDragDrop(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int flags = wxDrag_CopyOnly;
        ::wxDropSource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxDropSource, &sipCpp, &flags))
        {
            ::wxDragResult sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDropSource::DoDragDrop(flags) : sipCpp->DoDragDrop(flags));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxDragResult);
        }
    }

    sipNoMethod(sipParseErr, sipName_DropSource, sipName_DoDragDrop, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDropSource_GetDataObject, "GetDataObject() -> DataObject\n"
"\n"
"Returns the wxDataObject object that has been assigned previously.");

extern "C" {static PyObject *meth_wxDropSource_GetDataObject(PyObject *, PyObject *);}
static PyObject *meth_wxDropSource_GetDataObject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDropSource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDropSource, &sipCpp))
        {
            ::wxDataObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDataObject();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDataObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DropSource, sipName_GetDataObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDropSource_GiveFeedback, "GiveFeedback(effect) -> bool\n"
"\n"
"You may give some custom UI feedback during the drag and drop\n"
"operation by overriding this function.");

extern "C" {static PyObject *meth_wxDropSource_GiveFeedback(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDropSource_GiveFeedback(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxDragResult effect;
        ::wxDropSource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_effect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxDropSource, &sipCpp, sipType_wxDragResult, &effect))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDropSource::GiveFeedback(effect) : sipCpp->GiveFeedback(effect));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DropSource, sipName_GiveFeedback, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDropSource_SetCursor, "SetCursor(res, cursor) -> None\n"
"\n"
"Set the icon to use for a certain drag result.");

extern "C" {static PyObject *meth_wxDropSource_SetCursor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDropSource_SetCursor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDragResult res;
        const ::wxCursorBundle* cursor;
        ::wxDropSource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_res,
            sipName_cursor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BEJ9", &sipSelf, sipType_wxDropSource, &sipCpp, sipType_wxDragResult, &res, sipType_wxCursorBundle, &cursor))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxDropSource_SetCursor(sipCpp, res, cursor);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DropSource, sipName_SetCursor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDropSource_SetIcon, "SetIcon(res, icon) -> None\n"
"\n"
"Set the icon to use for a certain drag result.");

extern "C" {static PyObject *meth_wxDropSource_SetIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDropSource_SetIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDragResult res;
        const ::wxIcon* icon;
        ::wxDropSource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_res,
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BEJ9", &sipSelf, sipType_wxDropSource, &sipCpp, sipType_wxDragResult, &res, sipType_wxIcon, &icon))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxDropSource_SetIcon(sipCpp, res, icon);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DropSource, sipName_SetIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDropSource_SetData, "SetData(data) -> None\n"
"\n"
"Sets the data wxDataObject associated with the drop source.");

extern "C" {static PyObject *meth_wxDropSource_SetData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDropSource_SetData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDataObject* data;
        ::wxDropSource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDropSource, &sipCpp, sipType_wxDataObject, &data))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetData(*data);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DropSource, sipName_SetData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDropSource(void *, int);}
static void release_wxDropSource(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxDropSource *>(sipCppV);
    else
        delete reinterpret_cast< ::wxDropSource *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxDropSource(Py_ssize_t);}
static void *array_wxDropSource(Py_ssize_t sipNrElem)
{
    return new ::wxDropSource[sipNrElem];
}


extern "C" {static void array_delete_wxDropSource(void *);}
static void array_delete_wxDropSource(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxDropSource *>(sipCpp);
}


extern "C" {static void dealloc_wxDropSource(sipSimpleWrapper *);}
static void dealloc_wxDropSource(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxDropSource *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDropSource(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxDropSource(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDropSource(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxDropSource *sipCpp = SIP_NULLPTR;

    {
        ::wxWindow* win = nullptr;

        static const char *sipKwdList[] = {
            sipName_win,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J8", sipType_wxWindow, &win))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxDropSource(win);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        ::wxDataObject* data;
        ::wxWindow* win = nullptr;

        static const char *sipKwdList[] = {
            sipName_data,
            sipName_win,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9|J8", sipType_wxDataObject, &data, sipType_wxWindow, &win))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxDropSource(*data, win);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxDropSource[] = {
    {sipName_DoDragDrop, SIP_MLMETH_CAST(meth_wxDropSource_DoDragDrop), METH_VARARGS|METH_KEYWORDS, doc_wxDropSource_DoDragDrop},
    {sipName_GetDataObject, meth_wxDropSource_GetDataObject, METH_VARARGS, doc_wxDropSource_GetDataObject},
    {sipName_GiveFeedback, SIP_MLMETH_CAST(meth_wxDropSource_GiveFeedback), METH_VARARGS|METH_KEYWORDS, doc_wxDropSource_GiveFeedback},
    {sipName_SetCursor, SIP_MLMETH_CAST(meth_wxDropSource_SetCursor), METH_VARARGS|METH_KEYWORDS, doc_wxDropSource_SetCursor},
    {sipName_SetData, SIP_MLMETH_CAST(meth_wxDropSource_SetData), METH_VARARGS|METH_KEYWORDS, doc_wxDropSource_SetData},
    {sipName_SetIcon, SIP_MLMETH_CAST(meth_wxDropSource_SetIcon), METH_VARARGS|METH_KEYWORDS, doc_wxDropSource_SetIcon}
};

sipVariableDef variables_wxDropSource[] = {
    {PropertyVariable, sipName_DataObject, &methods_wxDropSource[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxDropSource, "DropSource(win=nullptr) -> None\n"
"DropSource(data, win=nullptr) -> None\n"
"\n"
"This class represents a source for a drag and drop operation.");


sipClassTypeDef sipTypeDef__core_wxDropSource = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxDropSource,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_DropSource,
        {0, 0, 1},
        6, methods_wxDropSource,
        0, SIP_NULLPTR,
        1, variables_wxDropSource,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxDropSource,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxDropSource,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxDropSource,
    SIP_NULLPTR,
    array_wxDropSource,
    SIP_NULLPTR,
    release_wxDropSource,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxDropSource,
    sizeof (::wxDropSource),
};
