/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/textctrl.h>
        #include <wx/colour.h>
        #include <wx/font.h>


PyDoc_STRVAR(doc_wxRichTextAttr_Copy, "Copy(attr) -> None\n"
"\n"
"Copy function.");

extern "C" {static PyObject *meth_wxRichTextAttr_Copy(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttr_Copy(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextAttr* attr;
        ::wxRichTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextAttr, &sipCpp, sipType_wxRichTextAttr, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Copy(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextAttr, sipName_Copy, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextAttr_EqPartial, "EqPartial(attr, weakTest=True) -> bool\n"
"\n"
"Partial equality test.");

extern "C" {static PyObject *meth_wxRichTextAttr_EqPartial(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttr_EqPartial(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextAttr* attr;
        bool weakTest = 1;
        const ::wxRichTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_weakTest,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|b", &sipSelf, sipType_wxRichTextAttr, &sipCpp, sipType_wxRichTextAttr, &attr, &weakTest))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EqPartial(*attr, weakTest);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextAttr, sipName_EqPartial, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextAttr_Apply, "Apply(style, compareWith=None) -> bool\n"
"\n"
"Merges the given attributes.");

extern "C" {static PyObject *meth_wxRichTextAttr_Apply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttr_Apply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextAttr* style;
        const ::wxRichTextAttr* compareWith = 0;
        ::wxRichTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
            sipName_compareWith,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J8", &sipSelf, sipType_wxRichTextAttr, &sipCpp, sipType_wxRichTextAttr, &style, sipType_wxRichTextAttr, &compareWith))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Apply(*style, compareWith);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextAttr, sipName_Apply, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextAttr_CollectCommonAttributes, "CollectCommonAttributes(attr, clashingAttr, absentAttr) -> None\n"
"\n"
"Collects the attributes that are common to a range of content,\n"
"building up a note of which attributes are absent in some objects and\n"
"which clash in some objects.");

extern "C" {static PyObject *meth_wxRichTextAttr_CollectCommonAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttr_CollectCommonAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextAttr* attr;
        ::wxRichTextAttr* clashingAttr;
        ::wxRichTextAttr* absentAttr;
        ::wxRichTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_clashingAttr,
            sipName_absentAttr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J9", &sipSelf, sipType_wxRichTextAttr, &sipCpp, sipType_wxRichTextAttr, &attr, sipType_wxRichTextAttr, &clashingAttr, sipType_wxRichTextAttr, &absentAttr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CollectCommonAttributes(*attr, *clashingAttr, *absentAttr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextAttr, sipName_CollectCommonAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextAttr_RemoveStyle, "RemoveStyle(attr) -> bool\n"
"\n"
"Removes the specified attributes from this object.");

extern "C" {static PyObject *meth_wxRichTextAttr_RemoveStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttr_RemoveStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextAttr* attr;
        ::wxRichTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextAttr, &sipCpp, sipType_wxRichTextAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveStyle(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextAttr, sipName_RemoveStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextAttr_GetTextBoxAttr, "GetTextBoxAttr() -> TextBoxAttr\n"
"\n"
"Returns the text box attributes.");

extern "C" {static PyObject *meth_wxRichTextAttr_GetTextBoxAttr(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttr_GetTextBoxAttr(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAttr, &sipCpp))
        {
            ::wxTextBoxAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTextBoxAttr();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTextBoxAttr, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextAttr, sipName_GetTextBoxAttr, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextAttr_SetTextBoxAttr, "SetTextBoxAttr(attr) -> None\n"
"\n"
"Set the text box attributes.");

extern "C" {static PyObject *meth_wxRichTextAttr_SetTextBoxAttr(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttr_SetTextBoxAttr(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextBoxAttr* attr;
        ::wxRichTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextAttr, &sipCpp, sipType_wxTextBoxAttr, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextBoxAttr(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextAttr, sipName_SetTextBoxAttr, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextAttr_IsDefault, "IsDefault() -> bool\n"
"\n"
"Returns true if no attributes are set.");

extern "C" {static PyObject *meth_wxRichTextAttr_IsDefault(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttr_IsDefault(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDefault();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextAttr, sipName_IsDefault, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxRichTextAttr___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxRichTextAttr___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxRichTextAttr *sipCpp = reinterpret_cast< ::wxRichTextAttr *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxRichTextAttr));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextAttr* attr;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxRichTextAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = !sipCpp->::wxRichTextAttr::operator==(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxRichTextAttr, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxRichTextAttr___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxRichTextAttr___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxRichTextAttr *sipCpp = reinterpret_cast< ::wxRichTextAttr *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxRichTextAttr));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextAttr* attr;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxRichTextAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxRichTextAttr::operator==(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxRichTextAttr, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextAttr(void *, const sipTypeDef *);}
static void *cast_wxRichTextAttr(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxRichTextAttr *sipCpp = reinterpret_cast< ::wxRichTextAttr *>(sipCppV);

    if (targetType == sipType_wxRichTextAttr)
        return sipCppV;

    if (targetType == sipType_wxTextAttr)
        return static_cast< ::wxTextAttr *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextAttr(void *, int);}
static void release_wxRichTextAttr(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRichTextAttr *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRichTextAttr(Py_ssize_t);}
static void *array_wxRichTextAttr(Py_ssize_t sipNrElem)
{
    return new ::wxRichTextAttr[sipNrElem];
}


extern "C" {static void array_delete_wxRichTextAttr(void *);}
static void array_delete_wxRichTextAttr(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxRichTextAttr *>(sipCpp);
}


extern "C" {static void assign_wxRichTextAttr(void *, Py_ssize_t, void *);}
static void assign_wxRichTextAttr(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRichTextAttr *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRichTextAttr *>(sipSrc);
}


extern "C" {static void *copy_wxRichTextAttr(const void *, Py_ssize_t);}
static void *copy_wxRichTextAttr(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxRichTextAttr(reinterpret_cast<const ::wxRichTextAttr *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextAttr(sipSimpleWrapper *);}
static void dealloc_wxRichTextAttr(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextAttr(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextAttr(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextAttr(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxRichTextAttr *sipCpp = SIP_NULLPTR;

    {
        const ::wxTextAttr* attr;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxTextAttr, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextAttr(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxRichTextAttr* attr;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxRichTextAttr, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextAttr(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextAttr();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextAttr[] = {{59, 0, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxRichTextAttr[] = {
    {(void *)slot_wxRichTextAttr___ne__, ne_slot},
    {(void *)slot_wxRichTextAttr___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxRichTextAttr[] = {
    {sipName_Apply, SIP_MLMETH_CAST(meth_wxRichTextAttr_Apply), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextAttr_Apply},
    {sipName_CollectCommonAttributes, SIP_MLMETH_CAST(meth_wxRichTextAttr_CollectCommonAttributes), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextAttr_CollectCommonAttributes},
    {sipName_Copy, SIP_MLMETH_CAST(meth_wxRichTextAttr_Copy), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextAttr_Copy},
    {sipName_EqPartial, SIP_MLMETH_CAST(meth_wxRichTextAttr_EqPartial), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextAttr_EqPartial},
    {sipName_GetTextBoxAttr, meth_wxRichTextAttr_GetTextBoxAttr, METH_VARARGS, doc_wxRichTextAttr_GetTextBoxAttr},
    {sipName_IsDefault, meth_wxRichTextAttr_IsDefault, METH_VARARGS, doc_wxRichTextAttr_IsDefault},
    {sipName_RemoveStyle, SIP_MLMETH_CAST(meth_wxRichTextAttr_RemoveStyle), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextAttr_RemoveStyle},
    {sipName_SetTextBoxAttr, SIP_MLMETH_CAST(meth_wxRichTextAttr_SetTextBoxAttr), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextAttr_SetTextBoxAttr}
};


extern "C" {static PyObject *varget_wxRichTextAttr_m_textBoxAttr(void *, PyObject *, PyObject *);}
static PyObject *varget_wxRichTextAttr_m_textBoxAttr(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
    ::wxTextBoxAttr*sipVal;
    ::wxRichTextAttr *sipCpp = reinterpret_cast< ::wxRichTextAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -6);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_textBoxAttr;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextBoxAttr, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -5, sipPySelf);
        sipKeepReference(sipPySelf, -6, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxRichTextAttr_m_textBoxAttr(void *, PyObject *, PyObject *);}
static int varset_wxRichTextAttr_m_textBoxAttr(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::wxTextBoxAttr*sipVal;
    ::wxRichTextAttr *sipCpp = reinterpret_cast< ::wxRichTextAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextBoxAttr *>(sipForceConvertToType(sipPy, sipType_wxTextBoxAttr, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_textBoxAttr = *sipVal;

    return 0;
}

sipVariableDef variables_wxRichTextAttr[] = {
    {PropertyVariable, sipName_TextBoxAttr, &methods_wxRichTextAttr[4], &methods_wxRichTextAttr[7], SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_textBoxAttr, (PyMethodDef *)varget_wxRichTextAttr_m_textBoxAttr, (PyMethodDef *)varset_wxRichTextAttr_m_textBoxAttr, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextAttr, "RichTextAttr(attr) -> None\n"
"RichTextAttr(attr) -> None\n"
"RichTextAttr() -> None\n"
"\n"
"A class representing enhanced attributes for rich text objects.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextAttr = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxRichTextAttr,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_RichTextAttr,
        {0, 0, 1},
        8, methods_wxRichTextAttr,
        0, SIP_NULLPTR,
        2, variables_wxRichTextAttr,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextAttr,
    -1,
    -1,
    supers_wxRichTextAttr,
    slots_wxRichTextAttr,
    init_type_wxRichTextAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRichTextAttr,
    assign_wxRichTextAttr,
    array_wxRichTextAttr,
    copy_wxRichTextAttr,
    release_wxRichTextAttr,
    cast_wxRichTextAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxRichTextAttr,
    sizeof (::wxRichTextAttr),
};
