/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_glcanvas.h"
        #include <wx/glcanvas.h>



PyDoc_STRVAR(doc_wxGLContextAttrs_CoreProfile, "CoreProfile() -> GLContextAttrs\n"
"\n"
"Request an OpenGL core profile for the context.");

extern "C" {static PyObject *meth_wxGLContextAttrs_CoreProfile(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_CoreProfile(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->CoreProfile();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_CoreProfile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_MajorVersion, "MajorVersion(val) -> GLContextAttrs\n"
"\n"
"Request specific OpenGL core major version number (>= 3).");

extern "C" {static PyObject *meth_wxGLContextAttrs_MajorVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_MajorVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int val;
        ::wxGLContextAttrs *sipCpp;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxGLContextAttrs, &sipCpp, &val))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MajorVersion(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_MajorVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_MinorVersion, "MinorVersion(val) -> GLContextAttrs\n"
"\n"
"Request specific OpenGL core minor version number.");

extern "C" {static PyObject *meth_wxGLContextAttrs_MinorVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_MinorVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int val;
        ::wxGLContextAttrs *sipCpp;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxGLContextAttrs, &sipCpp, &val))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MinorVersion(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_MinorVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_OGLVersion, "OGLVersion(vmayor, vminor) -> GLContextAttrs\n"
"\n"
"An easy way of requesting an OpenGL version.");

extern "C" {static PyObject *meth_wxGLContextAttrs_OGLVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_OGLVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int vmayor;
        int vminor;
        ::wxGLContextAttrs *sipCpp;

        static const char *sipKwdList[] = {
            sipName_vmayor,
            sipName_vminor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxGLContextAttrs, &sipCpp, &vmayor, &vminor))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->OGLVersion(vmayor, vminor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_OGLVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_CompatibilityProfile, "CompatibilityProfile() -> GLContextAttrs\n"
"\n"
"Request a type of context with all OpenGL features from version 1.0 to\n"
"the newest available by the GPU driver.");

extern "C" {static PyObject *meth_wxGLContextAttrs_CompatibilityProfile(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_CompatibilityProfile(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->CompatibilityProfile();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_CompatibilityProfile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_ForwardCompatible, "ForwardCompatible() -> GLContextAttrs\n"
"\n"
"Request a forward-compatible context.");

extern "C" {static PyObject *meth_wxGLContextAttrs_ForwardCompatible(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_ForwardCompatible(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->ForwardCompatible();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_ForwardCompatible, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_ES2, "ES2() -> GLContextAttrs\n"
"\n"
"Request an ES or ES2 (\"Embedded Subsystem\") context.");

extern "C" {static PyObject *meth_wxGLContextAttrs_ES2(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_ES2(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->ES2();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_ES2, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_DebugCtx, "DebugCtx() -> GLContextAttrs\n"
"\n"
"Request debugging functionality.");

extern "C" {static PyObject *meth_wxGLContextAttrs_DebugCtx(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_DebugCtx(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->DebugCtx();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_DebugCtx, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_Robust, "Robust() -> GLContextAttrs\n"
"\n"
"Request robustness, or how OpenGL handles out-of-bounds buffer object\n"
"accesses and graphics reset notification behaviours.");

extern "C" {static PyObject *meth_wxGLContextAttrs_Robust(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_Robust(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Robust();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_Robust, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_NoResetNotify, "NoResetNotify() -> GLContextAttrs\n"
"\n"
"With robustness enabled, never deliver notification of reset events.");

extern "C" {static PyObject *meth_wxGLContextAttrs_NoResetNotify(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_NoResetNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->NoResetNotify();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_NoResetNotify, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_LoseOnReset, "LoseOnReset() -> GLContextAttrs\n"
"\n"
"With robustness enabled, if graphics reset happens, all context state\n"
"is lost.");

extern "C" {static PyObject *meth_wxGLContextAttrs_LoseOnReset(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_LoseOnReset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->LoseOnReset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_LoseOnReset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_ResetIsolation, "ResetIsolation() -> GLContextAttrs\n"
"\n"
"Request OpenGL to protect other applications or shared contexts from\n"
"reset side-effects.");

extern "C" {static PyObject *meth_wxGLContextAttrs_ResetIsolation(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_ResetIsolation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->ResetIsolation();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_ResetIsolation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_ReleaseFlush, "ReleaseFlush(val=1) -> GLContextAttrs\n"
"\n"
"Request OpenGL to avoid or not flushing pending commands when the\n"
"context is made no longer current (released).");

extern "C" {static PyObject *meth_wxGLContextAttrs_ReleaseFlush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_ReleaseFlush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int val = 1;
        ::wxGLContextAttrs *sipCpp;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxGLContextAttrs, &sipCpp, &val))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->ReleaseFlush(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_ReleaseFlush, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_PlatformDefaults, "PlatformDefaults() -> GLContextAttrs\n"
"\n"
"Set platform specific defaults.");

extern "C" {static PyObject *meth_wxGLContextAttrs_PlatformDefaults(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_PlatformDefaults(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            ::wxGLContextAttrs*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->PlatformDefaults();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGLContextAttrs, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_PlatformDefaults, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGLContextAttrs_EndList, "EndList() -> None\n"
"\n"
"The set of attributes must end with this one; otherwise, the GPU may\n"
"display nothing at all.");

extern "C" {static PyObject *meth_wxGLContextAttrs_EndList(PyObject *, PyObject *);}
static PyObject *meth_wxGLContextAttrs_EndList(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGLContextAttrs *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGLContextAttrs, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndList();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GLContextAttrs, sipName_EndList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxGLContextAttrs(void *, const sipTypeDef *);}
static void *cast_wxGLContextAttrs(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxGLContextAttrs *sipCpp = reinterpret_cast< ::wxGLContextAttrs *>(sipCppV);

    if (targetType == sipType_wxGLContextAttrs)
        return sipCppV;

    if (targetType == sipType_wxGLAttribsBase)
        return static_cast< ::wxGLAttribsBase *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGLContextAttrs(void *, int);}
static void release_wxGLContextAttrs(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxGLContextAttrs *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxGLContextAttrs(Py_ssize_t);}
static void *array_wxGLContextAttrs(Py_ssize_t sipNrElem)
{
    return new ::wxGLContextAttrs[sipNrElem];
}


extern "C" {static void array_delete_wxGLContextAttrs(void *);}
static void array_delete_wxGLContextAttrs(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxGLContextAttrs *>(sipCpp);
}


extern "C" {static void assign_wxGLContextAttrs(void *, Py_ssize_t, void *);}
static void assign_wxGLContextAttrs(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxGLContextAttrs *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxGLContextAttrs *>(sipSrc);
}


extern "C" {static void *copy_wxGLContextAttrs(const void *, Py_ssize_t);}
static void *copy_wxGLContextAttrs(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxGLContextAttrs(reinterpret_cast<const ::wxGLContextAttrs *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGLContextAttrs(sipSimpleWrapper *);}
static void dealloc_wxGLContextAttrs(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGLContextAttrs(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGLContextAttrs(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGLContextAttrs(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxGLContextAttrs *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGLContextAttrs();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::wxGLContextAttrs* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxGLContextAttrs, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGLContextAttrs(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxGLContextAttrs[] = {{0, 255, 1}};


static PyMethodDef methods_wxGLContextAttrs[] = {
    {sipName_CompatibilityProfile, meth_wxGLContextAttrs_CompatibilityProfile, METH_VARARGS, doc_wxGLContextAttrs_CompatibilityProfile},
    {sipName_CoreProfile, meth_wxGLContextAttrs_CoreProfile, METH_VARARGS, doc_wxGLContextAttrs_CoreProfile},
    {sipName_DebugCtx, meth_wxGLContextAttrs_DebugCtx, METH_VARARGS, doc_wxGLContextAttrs_DebugCtx},
    {sipName_ES2, meth_wxGLContextAttrs_ES2, METH_VARARGS, doc_wxGLContextAttrs_ES2},
    {sipName_EndList, meth_wxGLContextAttrs_EndList, METH_VARARGS, doc_wxGLContextAttrs_EndList},
    {sipName_ForwardCompatible, meth_wxGLContextAttrs_ForwardCompatible, METH_VARARGS, doc_wxGLContextAttrs_ForwardCompatible},
    {sipName_LoseOnReset, meth_wxGLContextAttrs_LoseOnReset, METH_VARARGS, doc_wxGLContextAttrs_LoseOnReset},
    {sipName_MajorVersion, SIP_MLMETH_CAST(meth_wxGLContextAttrs_MajorVersion), METH_VARARGS|METH_KEYWORDS, doc_wxGLContextAttrs_MajorVersion},
    {sipName_MinorVersion, SIP_MLMETH_CAST(meth_wxGLContextAttrs_MinorVersion), METH_VARARGS|METH_KEYWORDS, doc_wxGLContextAttrs_MinorVersion},
    {sipName_NoResetNotify, meth_wxGLContextAttrs_NoResetNotify, METH_VARARGS, doc_wxGLContextAttrs_NoResetNotify},
    {sipName_OGLVersion, SIP_MLMETH_CAST(meth_wxGLContextAttrs_OGLVersion), METH_VARARGS|METH_KEYWORDS, doc_wxGLContextAttrs_OGLVersion},
    {sipName_PlatformDefaults, meth_wxGLContextAttrs_PlatformDefaults, METH_VARARGS, doc_wxGLContextAttrs_PlatformDefaults},
    {sipName_ReleaseFlush, SIP_MLMETH_CAST(meth_wxGLContextAttrs_ReleaseFlush), METH_VARARGS|METH_KEYWORDS, doc_wxGLContextAttrs_ReleaseFlush},
    {sipName_ResetIsolation, meth_wxGLContextAttrs_ResetIsolation, METH_VARARGS, doc_wxGLContextAttrs_ResetIsolation},
    {sipName_Robust, meth_wxGLContextAttrs_Robust, METH_VARARGS, doc_wxGLContextAttrs_Robust}
};

PyDoc_STRVAR(doc_wxGLContextAttrs, "This class is used for setting context attributes.");


sipClassTypeDef sipTypeDef__glcanvas_wxGLContextAttrs = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxGLContextAttrs,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_GLContextAttrs,
        {0, 0, 1},
        15, methods_wxGLContextAttrs,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxGLContextAttrs,
    -1,
    -1,
    supers_wxGLContextAttrs,
    SIP_NULLPTR,
    init_type_wxGLContextAttrs,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxGLContextAttrs,
    assign_wxGLContextAttrs,
    array_wxGLContextAttrs,
    copy_wxGLContextAttrs,
    release_wxGLContextAttrs,
    cast_wxGLContextAttrs,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxGLContextAttrs,
    sizeof (::wxGLContextAttrs),
};
