/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/datetime.h>
    #include <wx/longlong.h>


PyDoc_STRVAR(doc_wxTimeSpan_Abs, "Abs() -> TimeSpan\n"
"\n"
"Returns the absolute value of the timespan: does not modify the\n"
"object.");

extern "C" {static PyObject *meth_wxTimeSpan_Abs(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Abs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(sipCpp->Abs());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Abs, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Add, "Add(diff) -> TimeSpan\n"
"\n"
"Adds the given wxTimeSpan to this wxTimeSpan and returns a reference to itself.");

extern "C" {static PyObject *meth_wxTimeSpan_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* diff;
        ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_diff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &diff))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Add(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Add, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Format, "Format(format=DefaultTimeSpanFormat) -> str\n"
"\n"
"Returns the string containing the formatted representation of the time\n"
"span.");

extern "C" {static PyObject *meth_wxTimeSpan_Format(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Format(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString& formatdef = wxDefaultTimeSpanFormat;
        const ::wxString* format = &formatdef;
        int formatState = 0;
        const ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J1", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxString, &format, &formatState))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->Format(*format));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(format), sipType_wxString, formatState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Format, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetDays, "GetDays() -> int\n"
"\n"
"Returns the difference in number of days.");

extern "C" {static PyObject *meth_wxTimeSpan_GetDays(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetDays(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDays();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetDays, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetHours, "GetHours() -> int\n"
"\n"
"Returns the difference in number of hours.");

extern "C" {static PyObject *meth_wxTimeSpan_GetHours(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetHours(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHours();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetHours, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetMilliseconds, "GetMilliseconds() -> int\n"
"\n"
"Returns the difference in number of milliseconds.");

extern "C" {static PyObject *meth_wxTimeSpan_GetMilliseconds(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetMilliseconds(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            ::wxLongLong*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxLongLong(sipCpp->GetMilliseconds());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxLongLong, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetMilliseconds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetMinutes, "GetMinutes() -> int\n"
"\n"
"Returns the difference in number of minutes.");

extern "C" {static PyObject *meth_wxTimeSpan_GetMinutes(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetMinutes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMinutes();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetMinutes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetSeconds, "GetSeconds() -> int\n"
"\n"
"Returns the difference in number of seconds.");

extern "C" {static PyObject *meth_wxTimeSpan_GetSeconds(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetSeconds(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            ::wxLongLong*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxLongLong(sipCpp->GetSeconds());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxLongLong, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetSeconds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetValue, "GetValue() -> int\n"
"\n"
"Returns the internal representation of timespan.");

extern "C" {static PyObject *meth_wxTimeSpan_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            ::wxLongLong*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxLongLong(sipCpp->GetValue());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxLongLong, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetWeeks, "GetWeeks() -> int\n"
"\n"
"Returns the difference in number of weeks.");

extern "C" {static PyObject *meth_wxTimeSpan_GetWeeks(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetWeeks(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWeeks();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetWeeks, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsEqualTo, "IsEqualTo(ts) -> bool\n"
"\n"
"Returns true if two timespans are equal.");

extern "C" {static PyObject *meth_wxTimeSpan_IsEqualTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsEqualTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* ts;
        const ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ts,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEqualTo(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsEqualTo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsLongerThan, "IsLongerThan(ts) -> bool\n"
"\n"
"Compares two timespans: works with the absolute values, i.e. -2 hours\n"
"is longer than 1 hour.");

extern "C" {static PyObject *meth_wxTimeSpan_IsLongerThan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsLongerThan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* ts;
        const ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ts,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsLongerThan(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsLongerThan, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsNegative, "IsNegative() -> bool\n"
"\n"
"Returns true if the timespan is negative.");

extern "C" {static PyObject *meth_wxTimeSpan_IsNegative(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsNegative(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsNegative();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsNegative, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsNull, "IsNull() -> bool\n"
"\n"
"Returns true if the timespan is empty.");

extern "C" {static PyObject *meth_wxTimeSpan_IsNull(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsNull();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsNull, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsPositive, "IsPositive() -> bool\n"
"\n"
"Returns true if the timespan is positive.");

extern "C" {static PyObject *meth_wxTimeSpan_IsPositive(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsPositive(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPositive();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsPositive, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsShorterThan, "IsShorterThan(ts) -> bool\n"
"\n"
"Compares two timespans: works with the absolute values, i.e. 1 hour is\n"
"shorter than -2 hours.");

extern "C" {static PyObject *meth_wxTimeSpan_IsShorterThan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsShorterThan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* ts;
        const ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ts,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsShorterThan(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsShorterThan, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Multiply, "Multiply(n) -> TimeSpan\n"
"\n"
"Multiplies this time span by n.");

extern "C" {static PyObject *meth_wxTimeSpan_Multiply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Multiply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int n;
        ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTimeSpan, &sipCpp, &n))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Multiply(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Multiply, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Neg, "Neg() -> TimeSpan\n"
"\n"
"Negate the value of the timespan.");

extern "C" {static PyObject *meth_wxTimeSpan_Neg(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Neg(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Neg();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Neg, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Negate, "Negate() -> TimeSpan\n"
"\n"
"Returns timespan with inverted sign.");

extern "C" {static PyObject *meth_wxTimeSpan_Negate(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Negate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(sipCpp->Negate());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Negate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Subtract, "Subtract(diff) -> TimeSpan\n"
"\n"
"Subtracts the given wxTimeSpan to this wxTimeSpan and returns a reference to itself.");

extern "C" {static PyObject *meth_wxTimeSpan_Subtract(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Subtract(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* diff;
        ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_diff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &diff))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Subtract(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Subtract, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Day, "Day() -> TimeSpan\n"
"\n"
"Returns the timespan for one day.");

extern "C" {static PyObject *meth_wxTimeSpan_Day(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Day(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Day());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Day, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Days, "Days(days) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of days.");

extern "C" {static PyObject *meth_wxTimeSpan_Days(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Days(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long days;

        static const char *sipKwdList[] = {
            sipName_days,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "l", &days))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Days(days));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Days, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Hour, "Hour() -> TimeSpan\n"
"\n"
"Returns the timespan for one hour.");

extern "C" {static PyObject *meth_wxTimeSpan_Hour(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Hour(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Hour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Hour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Hours, "Hours(hours) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of hours.");

extern "C" {static PyObject *meth_wxTimeSpan_Hours(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Hours(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long hours;

        static const char *sipKwdList[] = {
            sipName_hours,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "l", &hours))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Hours(hours));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Hours, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Millisecond, "Millisecond() -> TimeSpan\n"
"\n"
"Returns the timespan for one millisecond.");

extern "C" {static PyObject *meth_wxTimeSpan_Millisecond(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Millisecond(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Millisecond());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Millisecond, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Milliseconds, "Milliseconds(ms) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of milliseconds.");

extern "C" {static PyObject *meth_wxTimeSpan_Milliseconds(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Milliseconds(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxLongLong* ms;
        int msState = 0;

        static const char *sipKwdList[] = {
            sipName_ms,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxLongLong, &ms, &msState))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Milliseconds(*ms));
            Py_END_ALLOW_THREADS
            sipReleaseType(ms, sipType_wxLongLong, msState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Milliseconds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Minute, "Minute() -> TimeSpan\n"
"\n"
"Returns the timespan for one minute.");

extern "C" {static PyObject *meth_wxTimeSpan_Minute(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Minute(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Minute());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Minute, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Minutes, "Minutes(min) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of minutes.");

extern "C" {static PyObject *meth_wxTimeSpan_Minutes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Minutes(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long min;

        static const char *sipKwdList[] = {
            sipName_min,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "l", &min))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Minutes(min));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Minutes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Second, "Second() -> TimeSpan\n"
"\n"
"Returns the timespan for one second.");

extern "C" {static PyObject *meth_wxTimeSpan_Second(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Second(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Second());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Second, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Seconds, "Seconds(sec) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of seconds.");

extern "C" {static PyObject *meth_wxTimeSpan_Seconds(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Seconds(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxLongLong* sec;
        int secState = 0;

        static const char *sipKwdList[] = {
            sipName_sec,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxLongLong, &sec, &secState))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Seconds(*sec));
            Py_END_ALLOW_THREADS
            sipReleaseType(sec, sipType_wxLongLong, secState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Seconds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Week, "Week() -> TimeSpan\n"
"\n"
"Returns the timespan for one week.");

extern "C" {static PyObject *meth_wxTimeSpan_Week(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Week(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Week());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Week, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTimeSpan_Weeks, "Weeks(weeks) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of weeks.");

extern "C" {static PyObject *meth_wxTimeSpan_Weeks(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Weeks(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long weeks;

        static const char *sipKwdList[] = {
            sipName_weeks,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "l", &weeks))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan(::wxTimeSpan::Weeks(weeks));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Weeks, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxTimeSpan___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxTimeSpan::operator!=(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxTimeSpan::operator==(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___ge__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___ge__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxTimeSpan::operator>=(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ge_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___gt__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___gt__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxTimeSpan::operator>(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, gt_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___le__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___le__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxTimeSpan::operator<=(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, le_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___lt__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___lt__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxTimeSpan::operator<(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, lt_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___neg__(PyObject *);}
static PyObject *slot_wxTimeSpan___neg__(PyObject *sipSelf)
{
    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &-(*sipCpp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxTimeSpan___mul__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___mul__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTimeSpan* a0;
        int n;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9i", sipType_wxTimeSpan, &a0, &n))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan((*a0 * n));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxTimeSpan___imul__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___imul__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxTimeSpan)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int n;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->::wxTimeSpan::operator*=(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxTimeSpan___sub__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___sub__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTimeSpan* a0;
        const ::wxTimeSpan* ts;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_wxTimeSpan, &a0, sipType_wxTimeSpan, &ts))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan((*a0 - *ts));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxTimeSpan___isub__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___isub__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxTimeSpan)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* diff;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &diff))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->::wxTimeSpan::operator-=(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxTimeSpan___add__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___add__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTimeSpan* a0;
        const ::wxTimeSpan* ts;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_wxTimeSpan, &a0, sipType_wxTimeSpan, &ts))
        {
            ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxTimeSpan((*a0 + *ts));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxTimeSpan, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxTimeSpan___iadd__(PyObject *, PyObject *);}
static PyObject *slot_wxTimeSpan___iadd__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxTimeSpan)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTimeSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTimeSpan* diff;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &diff))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->::wxTimeSpan::operator+=(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTimeSpan(void *, int);}
static void release_wxTimeSpan(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTimeSpan *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxTimeSpan(Py_ssize_t);}
static void *array_wxTimeSpan(Py_ssize_t sipNrElem)
{
    return new ::wxTimeSpan[sipNrElem];
}


extern "C" {static void array_delete_wxTimeSpan(void *);}
static void array_delete_wxTimeSpan(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxTimeSpan *>(sipCpp);
}


extern "C" {static void assign_wxTimeSpan(void *, Py_ssize_t, void *);}
static void assign_wxTimeSpan(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTimeSpan *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTimeSpan *>(sipSrc);
}


extern "C" {static void *copy_wxTimeSpan(const void *, Py_ssize_t);}
static void *copy_wxTimeSpan(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxTimeSpan(reinterpret_cast<const ::wxTimeSpan *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTimeSpan(sipSimpleWrapper *);}
static void dealloc_wxTimeSpan(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTimeSpan(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTimeSpan(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTimeSpan(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxTimeSpan *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTimeSpan();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        long hours;
        long min = 0;
        ::wxLongLong secdef = 0;
        ::wxLongLong* sec = &secdef;
        int secState = 0;
        ::wxLongLong msecdef = 0;
        ::wxLongLong* msec = &msecdef;
        int msecState = 0;

        static const char *sipKwdList[] = {
            sipName_hours,
            sipName_min,
            sipName_sec,
            sipName_msec,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "l|lJ1J1", &hours, &min, sipType_wxLongLong, &sec, &secState, sipType_wxLongLong, &msec, &msecState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTimeSpan(hours, min, *sec, *msec);
            Py_END_ALLOW_THREADS
            sipReleaseType(sec, sipType_wxLongLong, secState);
            sipReleaseType(msec, sipType_wxLongLong, msecState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxTimeSpan* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxTimeSpan, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTimeSpan(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxTimeSpan[] = {
    {(void *)slot_wxTimeSpan___ne__, ne_slot},
    {(void *)slot_wxTimeSpan___eq__, eq_slot},
    {(void *)slot_wxTimeSpan___ge__, ge_slot},
    {(void *)slot_wxTimeSpan___gt__, gt_slot},
    {(void *)slot_wxTimeSpan___le__, le_slot},
    {(void *)slot_wxTimeSpan___lt__, lt_slot},
    {(void *)slot_wxTimeSpan___neg__, neg_slot},
    {(void *)slot_wxTimeSpan___mul__, mul_slot},
    {(void *)slot_wxTimeSpan___imul__, imul_slot},
    {(void *)slot_wxTimeSpan___sub__, sub_slot},
    {(void *)slot_wxTimeSpan___isub__, isub_slot},
    {(void *)slot_wxTimeSpan___add__, add_slot},
    {(void *)slot_wxTimeSpan___iadd__, iadd_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxTimeSpan[] = {
    {sipName_Abs, meth_wxTimeSpan_Abs, METH_VARARGS, doc_wxTimeSpan_Abs},
    {sipName_Add, SIP_MLMETH_CAST(meth_wxTimeSpan_Add), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Add},
    {sipName_Day, meth_wxTimeSpan_Day, METH_VARARGS, doc_wxTimeSpan_Day},
    {sipName_Days, SIP_MLMETH_CAST(meth_wxTimeSpan_Days), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Days},
    {sipName_Format, SIP_MLMETH_CAST(meth_wxTimeSpan_Format), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Format},
    {sipName_GetDays, meth_wxTimeSpan_GetDays, METH_VARARGS, doc_wxTimeSpan_GetDays},
    {sipName_GetHours, meth_wxTimeSpan_GetHours, METH_VARARGS, doc_wxTimeSpan_GetHours},
    {sipName_GetMilliseconds, meth_wxTimeSpan_GetMilliseconds, METH_VARARGS, doc_wxTimeSpan_GetMilliseconds},
    {sipName_GetMinutes, meth_wxTimeSpan_GetMinutes, METH_VARARGS, doc_wxTimeSpan_GetMinutes},
    {sipName_GetSeconds, meth_wxTimeSpan_GetSeconds, METH_VARARGS, doc_wxTimeSpan_GetSeconds},
    {sipName_GetValue, meth_wxTimeSpan_GetValue, METH_VARARGS, doc_wxTimeSpan_GetValue},
    {sipName_GetWeeks, meth_wxTimeSpan_GetWeeks, METH_VARARGS, doc_wxTimeSpan_GetWeeks},
    {sipName_Hour, meth_wxTimeSpan_Hour, METH_VARARGS, doc_wxTimeSpan_Hour},
    {sipName_Hours, SIP_MLMETH_CAST(meth_wxTimeSpan_Hours), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Hours},
    {sipName_IsEqualTo, SIP_MLMETH_CAST(meth_wxTimeSpan_IsEqualTo), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_IsEqualTo},
    {sipName_IsLongerThan, SIP_MLMETH_CAST(meth_wxTimeSpan_IsLongerThan), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_IsLongerThan},
    {sipName_IsNegative, meth_wxTimeSpan_IsNegative, METH_VARARGS, doc_wxTimeSpan_IsNegative},
    {sipName_IsNull, meth_wxTimeSpan_IsNull, METH_VARARGS, doc_wxTimeSpan_IsNull},
    {sipName_IsPositive, meth_wxTimeSpan_IsPositive, METH_VARARGS, doc_wxTimeSpan_IsPositive},
    {sipName_IsShorterThan, SIP_MLMETH_CAST(meth_wxTimeSpan_IsShorterThan), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_IsShorterThan},
    {sipName_Millisecond, meth_wxTimeSpan_Millisecond, METH_VARARGS, doc_wxTimeSpan_Millisecond},
    {sipName_Milliseconds, SIP_MLMETH_CAST(meth_wxTimeSpan_Milliseconds), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Milliseconds},
    {sipName_Minute, meth_wxTimeSpan_Minute, METH_VARARGS, doc_wxTimeSpan_Minute},
    {sipName_Minutes, SIP_MLMETH_CAST(meth_wxTimeSpan_Minutes), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Minutes},
    {sipName_Multiply, SIP_MLMETH_CAST(meth_wxTimeSpan_Multiply), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Multiply},
    {sipName_Neg, meth_wxTimeSpan_Neg, METH_VARARGS, doc_wxTimeSpan_Neg},
    {sipName_Negate, meth_wxTimeSpan_Negate, METH_VARARGS, doc_wxTimeSpan_Negate},
    {sipName_Second, meth_wxTimeSpan_Second, METH_VARARGS, doc_wxTimeSpan_Second},
    {sipName_Seconds, SIP_MLMETH_CAST(meth_wxTimeSpan_Seconds), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Seconds},
    {sipName_Subtract, SIP_MLMETH_CAST(meth_wxTimeSpan_Subtract), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Subtract},
    {sipName_Week, meth_wxTimeSpan_Week, METH_VARARGS, doc_wxTimeSpan_Week},
    {sipName_Weeks, SIP_MLMETH_CAST(meth_wxTimeSpan_Weeks), METH_VARARGS|METH_KEYWORDS, doc_wxTimeSpan_Weeks}
};

PyDoc_STRVAR(doc_wxTimeSpan, "TimeSpan() -> None\n"
"TimeSpan(hours, min=0, sec=0, msec=0) -> None\n"
"\n"
"wxTimeSpan class represents a time interval.");


sipClassTypeDef sipTypeDef__core_wxTimeSpan = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxTimeSpan,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_TimeSpan,
        {0, 0, 1},
        32, methods_wxTimeSpan,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxTimeSpan,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxTimeSpan,
    init_type_wxTimeSpan,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxTimeSpan,
    assign_wxTimeSpan,
    array_wxTimeSpan,
    copy_wxTimeSpan,
    release_wxTimeSpan,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxTimeSpan,
    sizeof (::wxTimeSpan),
};
