/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/icon.h>
        #include <wx/iconloc.h>
        #include <wx/bitmap.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    wxIcon* _wxIcon_ctor(const wxBitmap* bmp)
    {
        wxIcon* icon = new wxIcon();
        icon->CopyFromBitmap(*bmp);
        return icon;
    }
    bool _wxIcon_CreateFromHICON(wxIcon* self, long hicon)
    {
        #ifdef __WXMSW__
            return self->CreateFromHICON((WXHICON)LongToHandle(hicon));
        #else
            return false;
        #endif
    }
    int _wxIcon___nonzero__(wxIcon* self)
    {
        return self->IsOk();
    }
    int _wxIcon___bool__(wxIcon* self)
    {
        return self->IsOk();
    }
    long _wxIcon_GetHandle(wxIcon* self)
    {
        #ifdef __WXMSW__
            return HandleToLong(self->GetHandle());
        #else
            return 0;
        #endif
    }
    void _wxIcon_SetHandle(wxIcon* self, long handle)
    {
        #ifdef __WXMSW__
            self->SetHandle((WXHANDLE)LongToHandle(handle));
        #endif
    }


PyDoc_STRVAR(doc_wxIcon_CreateFromHICON, "CreateFromHICON(hicon) -> bool\n"
"\n"
"MSW-only method to create a wx.Icon from a native icon handle.");

extern "C" {static PyObject *meth_wxIcon_CreateFromHICON(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_CreateFromHICON(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long hicon;
        ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_hicon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxIcon, &sipCpp, &hicon))
        {
            bool sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxIcon_CreateFromHICON(sipCpp, hicon);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_CreateFromHICON, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_CopyFromBitmap, "CopyFromBitmap(bmp) -> None\n"
"\n"
"Copies bmp bitmap to this icon.");

extern "C" {static PyObject *meth_wxIcon_CopyFromBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_CopyFromBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBitmap* bmp;
        ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxIcon, &sipCpp, sipType_wxBitmap, &bmp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CopyFromBitmap(*bmp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_CopyFromBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetDepth, "GetDepth() -> int\n"
"\n"
"Gets the colour depth of the icon.");

extern "C" {static PyObject *meth_wxIcon_GetDepth(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetDepth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDepth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetDepth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetHeight, "GetHeight() -> int\n"
"\n"
"Gets the height of the icon in physical pixels.");

extern "C" {static PyObject *meth_wxIcon_GetHeight(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetLogicalHeight, "GetLogicalHeight() -> float\n"
"\n"
"Gets the height of the icon in logical pixels.");

extern "C" {static PyObject *meth_wxIcon_GetLogicalHeight(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetLogicalHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLogicalHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetLogicalHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetLogicalSize, "GetLogicalSize() -> Size\n"
"\n"
"Gets the size of the icon in logical pixels.");

extern "C" {static PyObject *meth_wxIcon_GetLogicalSize(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetLogicalSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetLogicalSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetLogicalSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetLogicalWidth, "GetLogicalWidth() -> float\n"
"\n"
"Gets the width of the icon in logical pixels.");

extern "C" {static PyObject *meth_wxIcon_GetLogicalWidth(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetLogicalWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLogicalWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetLogicalWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetScaleFactor, "GetScaleFactor() -> float\n"
"\n"
"Gets the scale factor of this icon.");

extern "C" {static PyObject *meth_wxIcon_GetScaleFactor(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetScaleFactor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetScaleFactor();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetScaleFactor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetSize, "GetSize() -> Size\n"
"\n"
"Gets the size of the icon in physical pixels.");

extern "C" {static PyObject *meth_wxIcon_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetWidth, "GetWidth() -> int\n"
"\n"
"Gets the width of the icon in physical pixels.");

extern "C" {static PyObject *meth_wxIcon_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if icon data is present.");

extern "C" {static PyObject *meth_wxIcon_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_LoadFile, "LoadFile(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1) -> bool\n"
"\n"
"Loads an icon from a file or resource.");

extern "C" {static PyObject *meth_wxIcon_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        ::wxBitmapType type = wxBITMAP_TYPE_ANY;
        int desiredWidth = -1;
        int desiredHeight = -1;
        ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
            sipName_desiredWidth,
            sipName_desiredHeight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|Eii", &sipSelf, sipType_wxIcon, &sipCpp, sipType_wxString, &name, &nameState, sipType_wxBitmapType, &type, &desiredWidth, &desiredHeight))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(*name, type, desiredWidth, desiredHeight);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_LoadFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_SetDepth, "SetDepth(depth) -> None");

extern "C" {static PyObject *meth_wxIcon_SetDepth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_SetDepth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int depth;
        ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_depth,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxIcon, &sipCpp, &depth))
        {
            if (sipDeprecated(sipName_Icon, sipName_SetDepth) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDepth(depth);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_SetDepth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_SetHeight, "SetHeight(height) -> None");

extern "C" {static PyObject *meth_wxIcon_SetHeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_SetHeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int height;
        ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxIcon, &sipCpp, &height))
        {
            if (sipDeprecated(sipName_Icon, sipName_SetHeight) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHeight(height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_SetHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_SetWidth, "SetWidth(width) -> None");

extern "C" {static PyObject *meth_wxIcon_SetWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_SetWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
        ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxIcon, &sipCpp, &width))
        {
            if (sipDeprecated(sipName_Icon, sipName_SetWidth) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWidth(width);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_SetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon___nonzero__, "__nonzero__() -> bool");

extern "C" {static PyObject *meth_wxIcon___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxIcon___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxIcon___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetHandle, "GetHandle() -> int");

extern "C" {static PyObject *meth_wxIcon_GetHandle(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetHandle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            long sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxIcon_GetHandle(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_SetHandle, "SetHandle(handle) -> None");

extern "C" {static PyObject *meth_wxIcon_SetHandle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_SetHandle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long handle;
        ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxIcon, &sipCpp, &handle))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxIcon_SetHandle(sipCpp, handle);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Icon, sipName_SetHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxIcon___bool__(PyObject *);}
static int slot_wxIcon___bool__(PyObject *sipSelf)
{
    ::wxIcon *sipCpp = reinterpret_cast< ::wxIcon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxIcon));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxIcon___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxIcon(void *, const sipTypeDef *);}
static void *cast_wxIcon(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxIcon *sipCpp = reinterpret_cast< ::wxIcon *>(sipCppV);

    if (targetType == sipType_wxIcon)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxGDIObject)->ctd_cast(static_cast< ::wxGDIObject *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxIcon(void *, int);}
static void release_wxIcon(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxIcon *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxIcon(Py_ssize_t);}
static void *array_wxIcon(Py_ssize_t sipNrElem)
{
    return new ::wxIcon[sipNrElem];
}


extern "C" {static void array_delete_wxIcon(void *);}
static void array_delete_wxIcon(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxIcon *>(sipCpp);
}


extern "C" {static void assign_wxIcon(void *, Py_ssize_t, void *);}
static void assign_wxIcon(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxIcon *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxIcon *>(sipSrc);
}


extern "C" {static void *copy_wxIcon(const void *, Py_ssize_t);}
static void *copy_wxIcon(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxIcon(reinterpret_cast<const ::wxIcon *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxIcon(sipSimpleWrapper *);}
static void dealloc_wxIcon(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxIcon(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxIcon(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxIcon(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxIcon *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxIcon();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxIcon* icon;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxIcon, &icon))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxIcon(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxString* name;
        int nameState = 0;
        ::wxBitmapType type = wxBITMAP_TYPE_ANY;
        int desiredWidth = -1;
        int desiredHeight = -1;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
            sipName_desiredWidth,
            sipName_desiredHeight,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|Eii", sipType_wxString, &name, &nameState, sipType_wxBitmapType, &type, &desiredWidth, &desiredHeight))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxIcon(*name, type, desiredWidth, desiredHeight);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxIconLocation* loc;

        static const char *sipKwdList[] = {
            sipName_loc,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxIconLocation, &loc))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxIcon(*loc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxBitmap* bmp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBitmap, &bmp))
        {
        PyErr_Clear();
        sipCpp = _wxIcon_ctor(bmp);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxIcon[] = {{226, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxIcon[] = {
    {(void *)slot_wxIcon___bool__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxIcon[] = {
    {sipName_CopyFromBitmap, SIP_MLMETH_CAST(meth_wxIcon_CopyFromBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxIcon_CopyFromBitmap},
    {sipName_CreateFromHICON, SIP_MLMETH_CAST(meth_wxIcon_CreateFromHICON), METH_VARARGS|METH_KEYWORDS, doc_wxIcon_CreateFromHICON},
    {sipName_GetDepth, meth_wxIcon_GetDepth, METH_VARARGS, doc_wxIcon_GetDepth},
    {sipName_GetHandle, meth_wxIcon_GetHandle, METH_VARARGS, doc_wxIcon_GetHandle},
    {sipName_GetHeight, meth_wxIcon_GetHeight, METH_VARARGS, doc_wxIcon_GetHeight},
    {sipName_GetLogicalHeight, meth_wxIcon_GetLogicalHeight, METH_VARARGS, doc_wxIcon_GetLogicalHeight},
    {sipName_GetLogicalSize, meth_wxIcon_GetLogicalSize, METH_VARARGS, doc_wxIcon_GetLogicalSize},
    {sipName_GetLogicalWidth, meth_wxIcon_GetLogicalWidth, METH_VARARGS, doc_wxIcon_GetLogicalWidth},
    {sipName_GetScaleFactor, meth_wxIcon_GetScaleFactor, METH_VARARGS, doc_wxIcon_GetScaleFactor},
    {sipName_GetSize, meth_wxIcon_GetSize, METH_VARARGS, doc_wxIcon_GetSize},
    {sipName_GetWidth, meth_wxIcon_GetWidth, METH_VARARGS, doc_wxIcon_GetWidth},
    {sipName_IsOk, meth_wxIcon_IsOk, METH_VARARGS, doc_wxIcon_IsOk},
    {sipName_LoadFile, SIP_MLMETH_CAST(meth_wxIcon_LoadFile), METH_VARARGS|METH_KEYWORDS, doc_wxIcon_LoadFile},
    {sipName_SetDepth, SIP_MLMETH_CAST(meth_wxIcon_SetDepth), METH_VARARGS|METH_KEYWORDS, doc_wxIcon_SetDepth},
    {sipName_SetHandle, SIP_MLMETH_CAST(meth_wxIcon_SetHandle), METH_VARARGS|METH_KEYWORDS, doc_wxIcon_SetHandle},
    {sipName_SetHeight, SIP_MLMETH_CAST(meth_wxIcon_SetHeight), METH_VARARGS|METH_KEYWORDS, doc_wxIcon_SetHeight},
    {sipName_SetWidth, SIP_MLMETH_CAST(meth_wxIcon_SetWidth), METH_VARARGS|METH_KEYWORDS, doc_wxIcon_SetWidth},
    {sipName___nonzero__, meth_wxIcon___nonzero__, METH_VARARGS, doc_wxIcon___nonzero__}
};

sipVariableDef variables_wxIcon[] = {
    {PropertyVariable, sipName_Width, &methods_wxIcon[10], &methods_wxIcon[16], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Size, &methods_wxIcon[9], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ScaleFactor, &methods_wxIcon[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LogicalWidth, &methods_wxIcon[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LogicalSize, &methods_wxIcon[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LogicalHeight, &methods_wxIcon[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Height, &methods_wxIcon[4], &methods_wxIcon[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Handle, &methods_wxIcon[3], &methods_wxIcon[14], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Depth, &methods_wxIcon[2], &methods_wxIcon[13], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxIcon, "Icon() -> None\n"
"Icon(icon) -> None\n"
"Icon(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1) -> None\n"
"Icon(loc) -> None\n"
"Icon(bmp) -> None\n"
"\n"
"An icon is a small rectangular bitmap usually used for denoting a\n"
"minimized application.");


sipClassTypeDef sipTypeDef__core_wxIcon = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxIcon,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_Icon,
        {0, 0, 1},
        18, methods_wxIcon,
        0, SIP_NULLPTR,
        9, variables_wxIcon,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxIcon,
    -1,
    -1,
    supers_wxIcon,
    slots_wxIcon,
    init_type_wxIcon,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxIcon,
    assign_wxIcon,
    array_wxIcon,
    copy_wxIcon,
    release_wxIcon,
    cast_wxIcon,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxIcon,
    sizeof (::wxIcon),
};
