/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/font.h>
        #include <wx/font.h>
        #include <wx/gdicmn.h>
        #include <wx/fontutil.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    bool _wxFont_AddPrivateFont(const wxString *filename)
    {
        #if wxUSE_PRIVATE_FONTS
            return wxFont::AddPrivateFont(*filename);
        #else
            wxPyRaiseNotImplemented();
            return false;
        #endif
    }
    int _wxFont___nonzero__(wxFont* self)
    {
        return self->IsOk();
    }
    int _wxFont___bool__(wxFont* self)
    {
        return self->IsOk();
    }
    void* _wxFont_GetHFONT(wxFont* self)
    {
        #ifdef __WXMSW__
            return self->GetHFONT();
        #else
            return 0;
        #endif
    }
    void* _wxFont_OSXGetCGFont(wxFont* self)
    {
        #ifdef __WXMAC__
            return self->OSXGetCGFont();
        #else
            return 0;
        #endif
    }
    void* _wxFont_GetPangoFontDescription(wxFont* self)
    {
        #ifdef __WXGTK__
            return self->GetNativeFontInfo()->description;
        #else
            return 0;
        #endif
    }
    bool _wxFont_CanUsePrivateFont()
    {
        return wxUSE_PRIVATE_FONTS;
    }
    void _wxFont__copyFrom(wxFont* self, const wxFont* other)
    {
        *self = *other;
    }


PyDoc_STRVAR(doc_wxFont_GetBaseFont, "GetBaseFont() -> Font\n"
"\n"
"Returns a font with the same face/size as the given one but with\n"
"normal weight and style and not underlined nor stricken through.");

extern "C" {static PyObject *meth_wxFont_GetBaseFont(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetBaseFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->GetBaseFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetBaseFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetEncoding, "GetEncoding() -> FontEncoding\n"
"\n"
"Returns the encoding of this font.");

extern "C" {static PyObject *meth_wxFont_GetEncoding(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetEncoding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFontEncoding sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEncoding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontEncoding);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetEncoding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetFaceName, "GetFaceName() -> str\n"
"\n"
"Returns the face name associated with the font, or the empty string if\n"
"there is no face information.");

extern "C" {static PyObject *meth_wxFont_GetFaceName(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetFaceName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetFaceName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetFaceName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetFamily, "GetFamily() -> FontFamily\n"
"\n"
"Gets the font family if possible.");

extern "C" {static PyObject *meth_wxFont_GetFamily(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetFamily(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFontFamily sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFamily();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontFamily);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetFamily, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetNativeFontInfoDesc, "GetNativeFontInfoDesc() -> str\n"
"\n"
"Returns the platform-dependent string completely describing this font.");

extern "C" {static PyObject *meth_wxFont_GetNativeFontInfoDesc(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetNativeFontInfoDesc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetNativeFontInfoDesc());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetNativeFontInfoDesc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetNativeFontInfoUserDesc, "GetNativeFontInfoUserDesc() -> str\n"
"\n"
"Returns a user-friendly string for this font object.");

extern "C" {static PyObject *meth_wxFont_GetNativeFontInfoUserDesc(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetNativeFontInfoUserDesc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetNativeFontInfoUserDesc());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetNativeFontInfoUserDesc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetNativeFontInfo, "GetNativeFontInfo() -> NativeFontInfo\n"
"\n"
"Returns a font with the same face/size as the given one but with\n"
"normal weight and style and not underlined nor stricken through.");

extern "C" {static PyObject *meth_wxFont_GetNativeFontInfo(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetNativeFontInfo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            const ::wxNativeFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNativeFontInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxNativeFontInfo *>(sipRes), sipType_wxNativeFontInfo, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetNativeFontInfo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetPointSize, "GetPointSize() -> int\n"
"\n"
"Gets the point size as an integer number.");

extern "C" {static PyObject *meth_wxFont_GetPointSize(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetPointSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPointSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetPointSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetFractionalPointSize, "GetFractionalPointSize() -> float\n"
"\n"
"Gets the point size as a floating number.");

extern "C" {static PyObject *meth_wxFont_GetFractionalPointSize(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetFractionalPointSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFractionalPointSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetFractionalPointSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetPixelSize, "GetPixelSize() -> Size\n"
"\n"
"Gets the pixel size.");

extern "C" {static PyObject *meth_wxFont_GetPixelSize(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetPixelSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetPixelSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetPixelSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetStyle, "GetStyle() -> FontStyle\n"
"\n"
"Gets the font style.");

extern "C" {static PyObject *meth_wxFont_GetStyle(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFontStyle sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontStyle);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetUnderlined, "GetUnderlined() -> bool\n"
"\n"
"Returns true if the font is underlined, false otherwise.");

extern "C" {static PyObject *meth_wxFont_GetUnderlined(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetUnderlined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUnderlined();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetUnderlined, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetStrikethrough, "GetStrikethrough() -> bool\n"
"\n"
"Returns true if the font is stricken-through, false otherwise.");

extern "C" {static PyObject *meth_wxFont_GetStrikethrough(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetStrikethrough(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStrikethrough();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetStrikethrough, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetWeight, "GetWeight() -> FontWeight\n"
"\n"
"Gets the font weight.");

extern "C" {static PyObject *meth_wxFont_GetWeight(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetWeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFontWeight sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontWeight);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetWeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetNumericWeight, "GetNumericWeight() -> int\n"
"\n"
"Gets the font weight as an integer value.");

extern "C" {static PyObject *meth_wxFont_GetNumericWeight(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetNumericWeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNumericWeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetNumericWeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_IsFixedWidth, "IsFixedWidth() -> bool\n"
"\n"
"Returns true if the font is a fixed width (or monospaced) font, false\n"
"if it is a proportional one or font is invalid.");

extern "C" {static PyObject *meth_wxFont_IsFixedWidth(PyObject *, PyObject *);}
static PyObject *meth_wxFont_IsFixedWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsFixedWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_IsFixedWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if this object is a valid font, false otherwise.");

extern "C" {static PyObject *meth_wxFont_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxFont_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_AddPrivateFont, "AddPrivateFont(filename) -> bool\n"
"\n"
"Specify the name of a file containing a TrueType font to be made\n"
"available to the current application.");

extern "C" {static PyObject *meth_wxFont_AddPrivateFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_AddPrivateFont(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* filename;
        int filenameState = 0;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &filename, &filenameState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont_AddPrivateFont(filename);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(filename), sipType_wxString, filenameState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_AddPrivateFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_Bold, "Bold() -> Font\n"
"\n"
"Returns a bold version of this font.");

extern "C" {static PyObject *meth_wxFont_Bold(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Bold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->Bold());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_Bold, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_Italic, "Italic() -> Font\n"
"\n"
"Returns an italic version of this font.");

extern "C" {static PyObject *meth_wxFont_Italic(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Italic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->Italic());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_Italic, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_Larger, "Larger() -> Font\n"
"\n"
"Returns a larger version of this font.");

extern "C" {static PyObject *meth_wxFont_Larger(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Larger(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->Larger());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_Larger, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_Smaller, "Smaller() -> Font\n"
"\n"
"Returns a smaller version of this font.");

extern "C" {static PyObject *meth_wxFont_Smaller(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Smaller(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->Smaller());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_Smaller, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_Underlined, "Underlined() -> Font\n"
"\n"
"Returns underlined version of this font.");

extern "C" {static PyObject *meth_wxFont_Underlined(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Underlined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->Underlined());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_Underlined, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_Strikethrough, "Strikethrough() -> Font\n"
"\n"
"Returns stricken-through version of this font.");

extern "C" {static PyObject *meth_wxFont_Strikethrough(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Strikethrough(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->Strikethrough());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_Strikethrough, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_MakeBold, "MakeBold() -> Font\n"
"\n"
"Changes this font to be bold.");

extern "C" {static PyObject *meth_wxFont_MakeBold(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeBold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeBold();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeBold, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_MakeItalic, "MakeItalic() -> Font\n"
"\n"
"Changes this font to be italic.");

extern "C" {static PyObject *meth_wxFont_MakeItalic(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeItalic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeItalic();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeItalic, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_MakeLarger, "MakeLarger() -> Font\n"
"\n"
"Changes this font to be larger.");

extern "C" {static PyObject *meth_wxFont_MakeLarger(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeLarger(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeLarger();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeLarger, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_MakeSmaller, "MakeSmaller() -> Font\n"
"\n"
"Changes this font to be smaller.");

extern "C" {static PyObject *meth_wxFont_MakeSmaller(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeSmaller(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeSmaller();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeSmaller, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_MakeUnderlined, "MakeUnderlined() -> Font\n"
"\n"
"Changes this font to be underlined.");

extern "C" {static PyObject *meth_wxFont_MakeUnderlined(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeUnderlined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeUnderlined();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeUnderlined, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_MakeStrikethrough, "MakeStrikethrough() -> Font\n"
"\n"
"Changes this font to be stricken-through.");

extern "C" {static PyObject *meth_wxFont_MakeStrikethrough(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeStrikethrough(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeStrikethrough();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeStrikethrough, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_Scale, "Scale(x) -> Font\n"
"\n"
"Changes the size of this font.");

extern "C" {static PyObject *meth_wxFont_Scale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_Scale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float x;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bf", &sipSelf, sipType_wxFont, &sipCpp, &x))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Scale(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_Scale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_Scaled, "Scaled(x) -> Font\n"
"\n"
"Returns a scaled version of this font.");

extern "C" {static PyObject *meth_wxFont_Scaled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_Scaled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float x;
        const ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bf", &sipSelf, sipType_wxFont, &sipCpp, &x))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->Scaled(x));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_Scaled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetEncoding, "SetEncoding(encoding) -> None\n"
"\n"
"Sets the encoding for this font.");

extern "C" {static PyObject *meth_wxFont_SetEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFontEncoding encoding;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontEncoding, &encoding))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEncoding(encoding);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetEncoding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetFaceName, "SetFaceName(faceName) -> bool\n"
"\n"
"Sets the facename for the font.");

extern "C" {static PyObject *meth_wxFont_SetFaceName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetFaceName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* faceName;
        int faceNameState = 0;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_faceName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxString, &faceName, &faceNameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetFaceName(*faceName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName), sipType_wxString, faceNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetFaceName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetFamily, "SetFamily(family) -> None\n"
"\n"
"Sets the font family.");

extern "C" {static PyObject *meth_wxFont_SetFamily(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetFamily(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFontFamily family;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_family,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontFamily, &family))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFamily(family);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetFamily, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetNativeFontInfo, "SetNativeFontInfo(info) -> bool\n"
"SetNativeFontInfo(info) -> None\n"
"\n"
"Creates the font corresponding to the given native font description\n"
"string which must have been previously returned by\n"
"GetNativeFontInfoDesc().\n"
"");

extern "C" {static PyObject *meth_wxFont_SetNativeFontInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetNativeFontInfo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* info;
        int infoState = 0;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxString, &info, &infoState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetNativeFontInfo(*info);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(info), sipType_wxString, infoState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxNativeFontInfo* info;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxNativeFontInfo, &info))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNativeFontInfo(*info);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetNativeFontInfo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetNativeFontInfoUserDesc, "SetNativeFontInfoUserDesc(info) -> bool\n"
"\n"
"Creates the font corresponding to the given native font description\n"
"string and returns true if the creation was successful.");

extern "C" {static PyObject *meth_wxFont_SetNativeFontInfoUserDesc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetNativeFontInfoUserDesc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* info;
        int infoState = 0;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxString, &info, &infoState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetNativeFontInfoUserDesc(*info);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(info), sipType_wxString, infoState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetNativeFontInfoUserDesc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetPointSize, "SetPointSize(pointSize) -> None\n"
"\n"
"Sets the font size in points to an integer value.");

extern "C" {static PyObject *meth_wxFont_SetPointSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetPointSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int pointSize;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pointSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxFont, &sipCpp, &pointSize))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPointSize(pointSize);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetPointSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetFractionalPointSize, "SetFractionalPointSize(pointSize) -> None\n"
"\n"
"Sets the font size in points.");

extern "C" {static PyObject *meth_wxFont_SetFractionalPointSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetFractionalPointSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double pointSize;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pointSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_wxFont, &sipCpp, &pointSize))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFractionalPointSize(pointSize);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetFractionalPointSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetPixelSize, "SetPixelSize(pixelSize) -> None\n"
"\n"
"Sets the pixel size.");

extern "C" {static PyObject *meth_wxFont_SetPixelSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetPixelSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSize* pixelSize;
        int pixelSizeState = 0;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxSize, &pixelSize, &pixelSizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPixelSize(*pixelSize);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(pixelSize), sipType_wxSize, pixelSizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetPixelSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetStyle, "SetStyle(style) -> None\n"
"\n"
"Sets the font style.");

extern "C" {static PyObject *meth_wxFont_SetStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFontStyle style;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontStyle, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStyle(style);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetSymbolicSize, "SetSymbolicSize(size) -> None\n"
"\n"
"Sets the font size using a predefined symbolic size name.");

extern "C" {static PyObject *meth_wxFont_SetSymbolicSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetSymbolicSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFontSymbolicSize size;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontSymbolicSize, &size))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSymbolicSize(size);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetSymbolicSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetSymbolicSizeRelativeTo, "SetSymbolicSizeRelativeTo(size, base) -> None\n"
"\n"
"Sets the font size compared to the base font size.");

extern "C" {static PyObject *meth_wxFont_SetSymbolicSizeRelativeTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetSymbolicSizeRelativeTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFontSymbolicSize size;
        int base;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BEi", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontSymbolicSize, &size, &base))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSymbolicSizeRelativeTo(size, base);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetSymbolicSizeRelativeTo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetUnderlined, "SetUnderlined(underlined) -> None\n"
"\n"
"Sets underlining.");

extern "C" {static PyObject *meth_wxFont_SetUnderlined(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetUnderlined(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool underlined;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_underlined,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxFont, &sipCpp, &underlined))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUnderlined(underlined);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetUnderlined, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetStrikethrough, "SetStrikethrough(strikethrough) -> None\n"
"\n"
"Sets strike-through attribute of the font.");

extern "C" {static PyObject *meth_wxFont_SetStrikethrough(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetStrikethrough(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool strikethrough;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strikethrough,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxFont, &sipCpp, &strikethrough))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStrikethrough(strikethrough);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetStrikethrough, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetWeight, "SetWeight(weight) -> None\n"
"\n"
"Sets the font weight.");

extern "C" {static PyObject *meth_wxFont_SetWeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetWeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFontWeight weight;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontWeight, &weight))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWeight(weight);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetWeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetNumericWeight, "SetNumericWeight(weight) -> None\n"
"\n"
"Sets the font weight using an integer value.");

extern "C" {static PyObject *meth_wxFont_SetNumericWeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetNumericWeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int weight;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxFont, &sipCpp, &weight))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNumericWeight(weight);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetNumericWeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_New, "New(pointSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> Font\n"
"New(pointSize, family, flags=FONTFLAG_DEFAULT, faceName='', encoding=FONTENCODING_DEFAULT) -> Font\n"
"New(pixelSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> Font\n"
"New(pixelSize, family, flags=FONTFLAG_DEFAULT, faceName='', encoding=FONTENCODING_DEFAULT) -> Font\n"
"New(nativeInfo) -> Font\n"
"New(nativeInfoString) -> Font\n"
"\n"
"This function takes the same parameters as the relative wxFont\n"
"constructor and returns a new font object allocated on the heap.\n"
"\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxFont_New(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_New(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int pointSize;
        ::wxFontFamily family;
        ::wxFontStyle style;
        ::wxFontWeight weight;
        bool underline = 0;
        const ::wxString& faceNamedef = wxEmptyString;
        const ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
        ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pointSize,
            sipName_family,
            sipName_style,
            sipName_weight,
            sipName_underline,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "iEEE|bJ1E", &pointSize, sipType_wxFontFamily, &family, sipType_wxFontStyle, &style, sipType_wxFontWeight, &weight, &underline, sipType_wxString, &faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
            ::wxFont*sipRes;
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxFont::New(pointSize, family, style, weight, underline, *faceName, encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName), sipType_wxString, faceNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    {
        int pointSize;
        ::wxFontFamily family;
        int flags = wxFONTFLAG_DEFAULT;
        const ::wxString& faceNamedef = wxEmptyString;
        const ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
        ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pointSize,
            sipName_family,
            sipName_flags,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "iE|iJ1E", &pointSize, sipType_wxFontFamily, &family, &flags, sipType_wxString, &faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
            ::wxFont*sipRes;
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxFont::New(pointSize, family, flags, *faceName, encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName), sipType_wxString, faceNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    {
        const ::wxSize* pixelSize;
        int pixelSizeState = 0;
        ::wxFontFamily family;
        ::wxFontStyle style;
        ::wxFontWeight weight;
        bool underline = 0;
        const ::wxString& faceNamedef = wxEmptyString;
        const ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
        ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
            sipName_family,
            sipName_style,
            sipName_weight,
            sipName_underline,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1EEE|bJ1E", sipType_wxSize, &pixelSize, &pixelSizeState, sipType_wxFontFamily, &family, sipType_wxFontStyle, &style, sipType_wxFontWeight, &weight, &underline, sipType_wxString, &faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
            ::wxFont*sipRes;
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxFont::New(*pixelSize, family, style, weight, underline, *faceName, encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(pixelSize), sipType_wxSize, pixelSizeState);
            sipReleaseType(const_cast< ::wxString *>(faceName), sipType_wxString, faceNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    {
        const ::wxSize* pixelSize;
        int pixelSizeState = 0;
        ::wxFontFamily family;
        int flags = wxFONTFLAG_DEFAULT;
        const ::wxString& faceNamedef = wxEmptyString;
        const ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
        ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
            sipName_family,
            sipName_flags,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1E|iJ1E", sipType_wxSize, &pixelSize, &pixelSizeState, sipType_wxFontFamily, &family, &flags, sipType_wxString, &faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
            ::wxFont*sipRes;
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxFont::New(*pixelSize, family, flags, *faceName, encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(pixelSize), sipType_wxSize, pixelSizeState);
            sipReleaseType(const_cast< ::wxString *>(faceName), sipType_wxString, faceNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    {
        const ::wxNativeFontInfo* nativeInfo;

        static const char *sipKwdList[] = {
            sipName_nativeInfo,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9", sipType_wxNativeFontInfo, &nativeInfo))
        {
            ::wxFont*sipRes;
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxFont::New(*nativeInfo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    {
        const ::wxString* nativeInfoString;
        int nativeInfoStringState = 0;

        static const char *sipKwdList[] = {
            sipName_nativeInfoString,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &nativeInfoString, &nativeInfoStringState))
        {
            ::wxFont*sipRes;
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxFont::New(*nativeInfoString);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(nativeInfoString), sipType_wxString, nativeInfoStringState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_New, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetDefaultEncoding, "GetDefaultEncoding() -> FontEncoding\n"
"\n"
"Returns the current application's default encoding.");

extern "C" {static PyObject *meth_wxFont_GetDefaultEncoding(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetDefaultEncoding(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxFontEncoding sipRes;
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxFont::GetDefaultEncoding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontEncoding);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetDefaultEncoding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_SetDefaultEncoding, "SetDefaultEncoding(encoding) -> None\n"
"\n"
"Sets the default font encoding.");

extern "C" {static PyObject *meth_wxFont_SetDefaultEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetDefaultEncoding(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFontEncoding encoding;

        static const char *sipKwdList[] = {
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "E", sipType_wxFontEncoding, &encoding))
        {
        if (!wxPyCheckForApp()) return NULL;
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxFont::SetDefaultEncoding(encoding);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_SetDefaultEncoding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetNumericWeightOf, "GetNumericWeightOf(weight) -> int\n"
"\n"
"Get the raw weight value corresponding to the given symbolic constant.");

extern "C" {static PyObject *meth_wxFont_GetNumericWeightOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetNumericWeightOf(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFontWeight weight;

        static const char *sipKwdList[] = {
            sipName_weight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "E", sipType_wxFontWeight, &weight))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxFont::GetNumericWeightOf(weight);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetNumericWeightOf, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont___nonzero__, "__nonzero__() -> bool");

extern "C" {static PyObject *meth_wxFont___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxFont___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetHFONT, "GetHFONT() -> Any\n"
"\n"
"Returns the font's native handle.");

extern "C" {static PyObject *meth_wxFont_GetHFONT(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetHFONT(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            void*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont_GetHFONT(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetHFONT, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_OSXGetCGFont, "OSXGetCGFont() -> Any\n"
"\n"
"Returns the font's native handle.");

extern "C" {static PyObject *meth_wxFont_OSXGetCGFont(PyObject *, PyObject *);}
static PyObject *meth_wxFont_OSXGetCGFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            void*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont_OSXGetCGFont(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_OSXGetCGFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_GetPangoFontDescription, "GetPangoFontDescription() -> Any\n"
"\n"
"Returns the font's native handle.");

extern "C" {static PyObject *meth_wxFont_GetPangoFontDescription(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetPangoFontDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            void*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont_GetPangoFontDescription(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_GetPangoFontDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont_CanUsePrivateFont, "CanUsePrivateFont() -> bool\n"
"\n"
"Returns ``True`` if this build of wxPython supports using\n"
":meth:`AddPrivateFont`.");

extern "C" {static PyObject *meth_wxFont_CanUsePrivateFont(PyObject *, PyObject *);}
static PyObject *meth_wxFont_CanUsePrivateFont(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            bool sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont_CanUsePrivateFont();
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName_CanUsePrivateFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFont__copyFrom, "_copyFrom(other) -> None\n"
"\n"
"For internal use only.");

extern "C" {static PyObject *meth_wxFont__copyFrom(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont__copyFrom(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont* other;
        ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFont, &other))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxFont__copyFrom(sipCpp, other);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Font, sipName__copyFrom, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxFont___bool__(PyObject *);}
static int slot_wxFont___bool__(PyObject *sipSelf)
{
    ::wxFont *sipCpp = reinterpret_cast< ::wxFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxFont));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxFont___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxFont___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxFont *sipCpp = reinterpret_cast< ::wxFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxFont));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont* font;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxFont, &font))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxFont::operator==(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxFont, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxFont___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxFont___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxFont *sipCpp = reinterpret_cast< ::wxFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxFont));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont* font;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxFont, &font))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxFont::operator!=(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxFont, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFont(void *, const sipTypeDef *);}
static void *cast_wxFont(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxFont *sipCpp = reinterpret_cast< ::wxFont *>(sipCppV);

    if (targetType == sipType_wxFont)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxGDIObject)->ctd_cast(static_cast< ::wxGDIObject *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFont(void *, int);}
static void release_wxFont(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxFont *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxFont(Py_ssize_t);}
static void *array_wxFont(Py_ssize_t sipNrElem)
{
    return new ::wxFont[sipNrElem];
}


extern "C" {static void array_delete_wxFont(void *);}
static void array_delete_wxFont(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxFont *>(sipCpp);
}


extern "C" {static void assign_wxFont(void *, Py_ssize_t, void *);}
static void assign_wxFont(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxFont *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxFont *>(sipSrc);
}


extern "C" {static void *copy_wxFont(const void *, Py_ssize_t);}
static void *copy_wxFont(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxFont(reinterpret_cast<const ::wxFont *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxFont(sipSimpleWrapper *);}
static void dealloc_wxFont(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFont(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxFont(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFont(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxFont *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFont();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxFont* font;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxFont, &font))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxFontInfo* fontInfo;

        static const char *sipKwdList[] = {
            sipName_fontInfo,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxFontInfo, &fontInfo))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFont(*fontInfo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        int pointSize;
        ::wxFontFamily family;
        ::wxFontStyle style;
        ::wxFontWeight weight;
        bool underline = 0;
        const ::wxString& faceNamedef = wxEmptyString;
        const ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
        ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pointSize,
            sipName_family,
            sipName_style,
            sipName_weight,
            sipName_underline,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iEEE|bJ1E", &pointSize, sipType_wxFontFamily, &family, sipType_wxFontStyle, &style, sipType_wxFontWeight, &weight, &underline, sipType_wxString, &faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFont(pointSize, family, style, weight, underline, *faceName, encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName), sipType_wxString, faceNameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxSize* pixelSize;
        int pixelSizeState = 0;
        ::wxFontFamily family;
        ::wxFontStyle style;
        ::wxFontWeight weight;
        bool underline = 0;
        const ::wxString& faceNamedef = wxEmptyString;
        const ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
        ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
            sipName_family,
            sipName_style,
            sipName_weight,
            sipName_underline,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1EEE|bJ1E", sipType_wxSize, &pixelSize, &pixelSizeState, sipType_wxFontFamily, &family, sipType_wxFontStyle, &style, sipType_wxFontWeight, &weight, &underline, sipType_wxString, &faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFont(*pixelSize, family, style, weight, underline, *faceName, encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(pixelSize), sipType_wxSize, pixelSizeState);
            sipReleaseType(const_cast< ::wxString *>(faceName), sipType_wxString, faceNameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxString* nativeInfoString;
        int nativeInfoStringState = 0;

        static const char *sipKwdList[] = {
            sipName_nativeInfoString,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxString, &nativeInfoString, &nativeInfoStringState))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFont(*nativeInfoString);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(nativeInfoString), sipType_wxString, nativeInfoStringState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxNativeFontInfo* nativeInfo;

        static const char *sipKwdList[] = {
            sipName_nativeInfo,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxNativeFontInfo, &nativeInfo))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFont(*nativeInfo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFont[] = {{226, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxFont[] = {
    {(void *)slot_wxFont___bool__, bool_slot},
    {(void *)slot_wxFont___eq__, eq_slot},
    {(void *)slot_wxFont___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxFont[] = {
    {sipName_AddPrivateFont, SIP_MLMETH_CAST(meth_wxFont_AddPrivateFont), METH_VARARGS|METH_KEYWORDS, doc_wxFont_AddPrivateFont},
    {sipName_Bold, meth_wxFont_Bold, METH_VARARGS, doc_wxFont_Bold},
    {sipName_CanUsePrivateFont, meth_wxFont_CanUsePrivateFont, METH_VARARGS, doc_wxFont_CanUsePrivateFont},
    {sipName_GetBaseFont, meth_wxFont_GetBaseFont, METH_VARARGS, doc_wxFont_GetBaseFont},
    {sipName_GetDefaultEncoding, meth_wxFont_GetDefaultEncoding, METH_VARARGS, doc_wxFont_GetDefaultEncoding},
    {sipName_GetEncoding, meth_wxFont_GetEncoding, METH_VARARGS, doc_wxFont_GetEncoding},
    {sipName_GetFaceName, meth_wxFont_GetFaceName, METH_VARARGS, doc_wxFont_GetFaceName},
    {sipName_GetFamily, meth_wxFont_GetFamily, METH_VARARGS, doc_wxFont_GetFamily},
    {sipName_GetFractionalPointSize, meth_wxFont_GetFractionalPointSize, METH_VARARGS, doc_wxFont_GetFractionalPointSize},
    {sipName_GetHFONT, meth_wxFont_GetHFONT, METH_VARARGS, doc_wxFont_GetHFONT},
    {sipName_GetNativeFontInfo, meth_wxFont_GetNativeFontInfo, METH_VARARGS, doc_wxFont_GetNativeFontInfo},
    {sipName_GetNativeFontInfoDesc, meth_wxFont_GetNativeFontInfoDesc, METH_VARARGS, doc_wxFont_GetNativeFontInfoDesc},
    {sipName_GetNativeFontInfoUserDesc, meth_wxFont_GetNativeFontInfoUserDesc, METH_VARARGS, doc_wxFont_GetNativeFontInfoUserDesc},
    {sipName_GetNumericWeight, meth_wxFont_GetNumericWeight, METH_VARARGS, doc_wxFont_GetNumericWeight},
    {sipName_GetNumericWeightOf, SIP_MLMETH_CAST(meth_wxFont_GetNumericWeightOf), METH_VARARGS|METH_KEYWORDS, doc_wxFont_GetNumericWeightOf},
    {sipName_GetPangoFontDescription, meth_wxFont_GetPangoFontDescription, METH_VARARGS, doc_wxFont_GetPangoFontDescription},
    {sipName_GetPixelSize, meth_wxFont_GetPixelSize, METH_VARARGS, doc_wxFont_GetPixelSize},
    {sipName_GetPointSize, meth_wxFont_GetPointSize, METH_VARARGS, doc_wxFont_GetPointSize},
    {sipName_GetStrikethrough, meth_wxFont_GetStrikethrough, METH_VARARGS, doc_wxFont_GetStrikethrough},
    {sipName_GetStyle, meth_wxFont_GetStyle, METH_VARARGS, doc_wxFont_GetStyle},
    {sipName_GetUnderlined, meth_wxFont_GetUnderlined, METH_VARARGS, doc_wxFont_GetUnderlined},
    {sipName_GetWeight, meth_wxFont_GetWeight, METH_VARARGS, doc_wxFont_GetWeight},
    {sipName_IsFixedWidth, meth_wxFont_IsFixedWidth, METH_VARARGS, doc_wxFont_IsFixedWidth},
    {sipName_IsOk, meth_wxFont_IsOk, METH_VARARGS, doc_wxFont_IsOk},
    {sipName_Italic, meth_wxFont_Italic, METH_VARARGS, doc_wxFont_Italic},
    {sipName_Larger, meth_wxFont_Larger, METH_VARARGS, doc_wxFont_Larger},
    {sipName_MakeBold, meth_wxFont_MakeBold, METH_VARARGS, doc_wxFont_MakeBold},
    {sipName_MakeItalic, meth_wxFont_MakeItalic, METH_VARARGS, doc_wxFont_MakeItalic},
    {sipName_MakeLarger, meth_wxFont_MakeLarger, METH_VARARGS, doc_wxFont_MakeLarger},
    {sipName_MakeSmaller, meth_wxFont_MakeSmaller, METH_VARARGS, doc_wxFont_MakeSmaller},
    {sipName_MakeStrikethrough, meth_wxFont_MakeStrikethrough, METH_VARARGS, doc_wxFont_MakeStrikethrough},
    {sipName_MakeUnderlined, meth_wxFont_MakeUnderlined, METH_VARARGS, doc_wxFont_MakeUnderlined},
    {sipName_New, SIP_MLMETH_CAST(meth_wxFont_New), METH_VARARGS|METH_KEYWORDS, doc_wxFont_New},
    {sipName_OSXGetCGFont, meth_wxFont_OSXGetCGFont, METH_VARARGS, doc_wxFont_OSXGetCGFont},
    {sipName_Scale, SIP_MLMETH_CAST(meth_wxFont_Scale), METH_VARARGS|METH_KEYWORDS, doc_wxFont_Scale},
    {sipName_Scaled, SIP_MLMETH_CAST(meth_wxFont_Scaled), METH_VARARGS|METH_KEYWORDS, doc_wxFont_Scaled},
    {sipName_SetDefaultEncoding, SIP_MLMETH_CAST(meth_wxFont_SetDefaultEncoding), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetDefaultEncoding},
    {sipName_SetEncoding, SIP_MLMETH_CAST(meth_wxFont_SetEncoding), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetEncoding},
    {sipName_SetFaceName, SIP_MLMETH_CAST(meth_wxFont_SetFaceName), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetFaceName},
    {sipName_SetFamily, SIP_MLMETH_CAST(meth_wxFont_SetFamily), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetFamily},
    {sipName_SetFractionalPointSize, SIP_MLMETH_CAST(meth_wxFont_SetFractionalPointSize), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetFractionalPointSize},
    {sipName_SetNativeFontInfo, SIP_MLMETH_CAST(meth_wxFont_SetNativeFontInfo), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetNativeFontInfo},
    {sipName_SetNativeFontInfoUserDesc, SIP_MLMETH_CAST(meth_wxFont_SetNativeFontInfoUserDesc), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetNativeFontInfoUserDesc},
    {sipName_SetNumericWeight, SIP_MLMETH_CAST(meth_wxFont_SetNumericWeight), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetNumericWeight},
    {sipName_SetPixelSize, SIP_MLMETH_CAST(meth_wxFont_SetPixelSize), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetPixelSize},
    {sipName_SetPointSize, SIP_MLMETH_CAST(meth_wxFont_SetPointSize), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetPointSize},
    {sipName_SetStrikethrough, SIP_MLMETH_CAST(meth_wxFont_SetStrikethrough), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetStrikethrough},
    {sipName_SetStyle, SIP_MLMETH_CAST(meth_wxFont_SetStyle), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetStyle},
    {sipName_SetSymbolicSize, SIP_MLMETH_CAST(meth_wxFont_SetSymbolicSize), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetSymbolicSize},
    {sipName_SetSymbolicSizeRelativeTo, SIP_MLMETH_CAST(meth_wxFont_SetSymbolicSizeRelativeTo), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetSymbolicSizeRelativeTo},
    {sipName_SetUnderlined, SIP_MLMETH_CAST(meth_wxFont_SetUnderlined), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetUnderlined},
    {sipName_SetWeight, SIP_MLMETH_CAST(meth_wxFont_SetWeight), METH_VARARGS|METH_KEYWORDS, doc_wxFont_SetWeight},
    {sipName_Smaller, meth_wxFont_Smaller, METH_VARARGS, doc_wxFont_Smaller},
    {sipName_Strikethrough, meth_wxFont_Strikethrough, METH_VARARGS, doc_wxFont_Strikethrough},
    {sipName_Underlined, meth_wxFont_Underlined, METH_VARARGS, doc_wxFont_Underlined},
    {sipName___nonzero__, meth_wxFont___nonzero__, METH_VARARGS, doc_wxFont___nonzero__},
    {sipName__copyFrom, SIP_MLMETH_CAST(meth_wxFont__copyFrom), METH_VARARGS|METH_KEYWORDS, doc_wxFont__copyFrom}
};

sipVariableDef variables_wxFont[] = {
    {PropertyVariable, sipName_Weight, &methods_wxFont[21], &methods_wxFont[51], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Style, &methods_wxFont[19], &methods_wxFont[47], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PixelSize, &methods_wxFont[16], &methods_wxFont[44], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PointSize, &methods_wxFont[17], &methods_wxFont[45], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NativeFontInfoUserDesc, &methods_wxFont[12], &methods_wxFont[42], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NativeFontInfoDesc, &methods_wxFont[11], &methods_wxFont[41], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Family, &methods_wxFont[7], &methods_wxFont[39], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FaceName, &methods_wxFont[6], &methods_wxFont[38], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Encoding, &methods_wxFont[5], &methods_wxFont[37], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxFont, "Font() -> None\n"
"Font(font) -> None\n"
"Font(fontInfo) -> None\n"
"Font(pointSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> None\n"
"Font(pixelSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> None\n"
"Font(nativeInfoString) -> None\n"
"Font(nativeInfo) -> None\n"
"\n"
"A font is an object which determines the appearance of text.");


sipClassTypeDef sipTypeDef__core_wxFont = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFont,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_Font,
        {0, 0, 1},
        57, methods_wxFont,
        0, SIP_NULLPTR,
        9, variables_wxFont,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxFont,
    -1,
    -1,
    supers_wxFont,
    slots_wxFont,
    init_type_wxFont,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxFont,
    assign_wxFont,
    array_wxFont,
    copy_wxFont,
    release_wxFont,
    cast_wxFont,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxFont,
    sizeof (::wxFont),
};
