/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/datetime.h>



PyDoc_STRVAR(doc_wxDateSpan_Add, "Add(other) -> DateSpan\n"
"\n"
"Adds the given wxDateSpan to this wxDateSpan and returns a reference to itself.");

extern "C" {static PyObject *meth_wxDateSpan_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan* other;
        ::wxDateSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDateSpan, &sipCpp, sipType_wxDateSpan, &other))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Add(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Add, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_GetDays, "GetDays() -> int\n"
"\n"
"Returns the number of days (not counting the weeks component) in this\n"
"date span.");

extern "C" {static PyObject *meth_wxDateSpan_GetDays(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_GetDays(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDays();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_GetDays, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_GetMonths, "GetMonths() -> int\n"
"\n"
"Returns the number of the months (not counting the years) in this date\n"
"span.");

extern "C" {static PyObject *meth_wxDateSpan_GetMonths(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_GetMonths(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMonths();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_GetMonths, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_GetTotalMonths, "GetTotalMonths() -> int\n"
"\n"
"Returns the combined number of months in this date span, counting both\n"
"years and months.");

extern "C" {static PyObject *meth_wxDateSpan_GetTotalMonths(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_GetTotalMonths(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTotalMonths();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_GetTotalMonths, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_GetTotalDays, "GetTotalDays() -> int\n"
"\n"
"Returns the combined number of days in this date span, counting both\n"
"weeks and days.");

extern "C" {static PyObject *meth_wxDateSpan_GetTotalDays(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_GetTotalDays(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTotalDays();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_GetTotalDays, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_GetWeeks, "GetWeeks() -> int\n"
"\n"
"Returns the number of weeks in this date span.");

extern "C" {static PyObject *meth_wxDateSpan_GetWeeks(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_GetWeeks(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWeeks();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_GetWeeks, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_GetYears, "GetYears() -> int\n"
"\n"
"Returns the number of years in this date span.");

extern "C" {static PyObject *meth_wxDateSpan_GetYears(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_GetYears(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetYears();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_GetYears, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Multiply, "Multiply(factor) -> DateSpan\n"
"\n"
"Multiplies this date span by the specified factor.");

extern "C" {static PyObject *meth_wxDateSpan_Multiply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Multiply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int factor;
        ::wxDateSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_factor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxDateSpan, &sipCpp, &factor))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Multiply(factor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Multiply, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Neg, "Neg() -> DateSpan\n"
"\n"
"Changes the sign of this date span.");

extern "C" {static PyObject *meth_wxDateSpan_Neg(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Neg(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDateSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateSpan, &sipCpp))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Neg();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Neg, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Negate, "Negate() -> DateSpan\n"
"\n"
"Returns a date span with the opposite sign.");

extern "C" {static PyObject *meth_wxDateSpan_Negate(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Negate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateSpan, &sipCpp))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan(sipCpp->Negate());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Negate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_SetDays, "SetDays(n) -> DateSpan\n"
"\n"
"Sets the number of days (without modifying any other components) in\n"
"this date span.");

extern "C" {static PyObject *meth_wxDateSpan_SetDays(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_SetDays(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int n;
        ::wxDateSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxDateSpan, &sipCpp, &n))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetDays(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_SetDays, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_SetMonths, "SetMonths(n) -> DateSpan\n"
"\n"
"Sets the number of months (without modifying any other components) in\n"
"this date span.");

extern "C" {static PyObject *meth_wxDateSpan_SetMonths(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_SetMonths(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int n;
        ::wxDateSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxDateSpan, &sipCpp, &n))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetMonths(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_SetMonths, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_SetWeeks, "SetWeeks(n) -> DateSpan\n"
"\n"
"Sets the number of weeks (without modifying any other components) in\n"
"this date span.");

extern "C" {static PyObject *meth_wxDateSpan_SetWeeks(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_SetWeeks(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int n;
        ::wxDateSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxDateSpan, &sipCpp, &n))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetWeeks(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_SetWeeks, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_SetYears, "SetYears(n) -> DateSpan\n"
"\n"
"Sets the number of years (without modifying any other components) in\n"
"this date span.");

extern "C" {static PyObject *meth_wxDateSpan_SetYears(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_SetYears(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int n;
        ::wxDateSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxDateSpan, &sipCpp, &n))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetYears(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_SetYears, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Subtract, "Subtract(other) -> DateSpan\n"
"\n"
"Subtracts the given wxDateSpan to this wxDateSpan and returns a reference to itself.");

extern "C" {static PyObject *meth_wxDateSpan_Subtract(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Subtract(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan* other;
        ::wxDateSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDateSpan, &sipCpp, sipType_wxDateSpan, &other))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Subtract(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Subtract, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Day, "Day() -> DateSpan\n"
"\n"
"Returns a date span object corresponding to one day.");

extern "C" {static PyObject *meth_wxDateSpan_Day(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Day(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan(::wxDateSpan::Day());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Day, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Days, "Days(days) -> DateSpan\n"
"\n"
"Returns a date span object corresponding to the given number of days.");

extern "C" {static PyObject *meth_wxDateSpan_Days(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Days(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int days;

        static const char *sipKwdList[] = {
            sipName_days,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "i", &days))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan(::wxDateSpan::Days(days));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Days, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Month, "Month() -> DateSpan\n"
"\n"
"Returns a date span object corresponding to one month.");

extern "C" {static PyObject *meth_wxDateSpan_Month(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Month(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan(::wxDateSpan::Month());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Month, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Months, "Months(mon) -> DateSpan\n"
"\n"
"Returns a date span object corresponding to the given number of\n"
"months.");

extern "C" {static PyObject *meth_wxDateSpan_Months(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Months(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int mon;

        static const char *sipKwdList[] = {
            sipName_mon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "i", &mon))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan(::wxDateSpan::Months(mon));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Months, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Week, "Week() -> DateSpan\n"
"\n"
"Returns a date span object corresponding to one week.");

extern "C" {static PyObject *meth_wxDateSpan_Week(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Week(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan(::wxDateSpan::Week());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Week, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Weeks, "Weeks(weeks) -> DateSpan\n"
"\n"
"Returns a date span object corresponding to the given number of weeks.");

extern "C" {static PyObject *meth_wxDateSpan_Weeks(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Weeks(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int weeks;

        static const char *sipKwdList[] = {
            sipName_weeks,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "i", &weeks))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan(::wxDateSpan::Weeks(weeks));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Weeks, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Year, "Year() -> DateSpan\n"
"\n"
"Returns a date span object corresponding to one year.");

extern "C" {static PyObject *meth_wxDateSpan_Year(PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Year(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan(::wxDateSpan::Year());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Year, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateSpan_Years, "Years(years) -> DateSpan\n"
"\n"
"Returns a date span object corresponding to the given number of years.");

extern "C" {static PyObject *meth_wxDateSpan_Years(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateSpan_Years(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int years;

        static const char *sipKwdList[] = {
            sipName_years,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "i", &years))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan(::wxDateSpan::Years(years));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DateSpan, sipName_Years, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxDateSpan___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxDateSpan___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxDateSpan *sipCpp = reinterpret_cast< ::wxDateSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDateSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan* ds;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxDateSpan, &ds))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxDateSpan::operator!=(*ds);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxDateSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxDateSpan___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxDateSpan___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxDateSpan *sipCpp = reinterpret_cast< ::wxDateSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDateSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan* ds;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxDateSpan, &ds))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxDateSpan::operator==(*ds);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxDateSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxDateSpan___mul__(PyObject *, PyObject *);}
static PyObject *slot_wxDateSpan___mul__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDateSpan* a0;
        int n;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9i", sipType_wxDateSpan, &a0, &n))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan((*a0 * n));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxDateSpan___imul__(PyObject *, PyObject *);}
static PyObject *slot_wxDateSpan___imul__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxDateSpan)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::wxDateSpan *sipCpp = reinterpret_cast< ::wxDateSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDateSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int factor;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &factor))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->::wxDateSpan::operator*=(factor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxDateSpan___neg__(PyObject *);}
static PyObject *slot_wxDateSpan___neg__(PyObject *sipSelf)
{
    ::wxDateSpan *sipCpp = reinterpret_cast< ::wxDateSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDateSpan));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &-(*sipCpp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxDateSpan___sub__(PyObject *, PyObject *);}
static PyObject *slot_wxDateSpan___sub__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDateSpan* a0;
        const ::wxDateSpan* ds;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_wxDateSpan, &a0, sipType_wxDateSpan, &ds))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan((*a0 - *ds));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxDateSpan___isub__(PyObject *, PyObject *);}
static PyObject *slot_wxDateSpan___isub__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxDateSpan)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::wxDateSpan *sipCpp = reinterpret_cast< ::wxDateSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDateSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan* other;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxDateSpan, &other))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->::wxDateSpan::operator-=(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxDateSpan___add__(PyObject *, PyObject *);}
static PyObject *slot_wxDateSpan___add__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDateSpan* a0;
        const ::wxDateSpan* ds;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_wxDateSpan, &a0, sipType_wxDateSpan, &ds))
        {
            ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateSpan((*a0 + *ds));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateSpan, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxDateSpan___iadd__(PyObject *, PyObject *);}
static PyObject *slot_wxDateSpan___iadd__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxDateSpan)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::wxDateSpan *sipCpp = reinterpret_cast< ::wxDateSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDateSpan));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDateSpan* other;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxDateSpan, &other))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->::wxDateSpan::operator+=(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDateSpan(void *, int);}
static void release_wxDateSpan(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDateSpan *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxDateSpan(Py_ssize_t);}
static void *array_wxDateSpan(Py_ssize_t sipNrElem)
{
    return new ::wxDateSpan[sipNrElem];
}


extern "C" {static void array_delete_wxDateSpan(void *);}
static void array_delete_wxDateSpan(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxDateSpan *>(sipCpp);
}


extern "C" {static void assign_wxDateSpan(void *, Py_ssize_t, void *);}
static void assign_wxDateSpan(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxDateSpan *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxDateSpan *>(sipSrc);
}


extern "C" {static void *copy_wxDateSpan(const void *, Py_ssize_t);}
static void *copy_wxDateSpan(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxDateSpan(reinterpret_cast<const ::wxDateSpan *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxDateSpan(sipSimpleWrapper *);}
static void dealloc_wxDateSpan(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDateSpan(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxDateSpan(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDateSpan(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxDateSpan *sipCpp = SIP_NULLPTR;

    {
        int years = 0;
        int months = 0;
        int weeks = 0;
        int days = 0;

        static const char *sipKwdList[] = {
            sipName_years,
            sipName_months,
            sipName_weeks,
            sipName_days,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|iiii", &years, &months, &weeks, &days))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxDateSpan(years, months, weeks, days);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxDateSpan* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxDateSpan, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxDateSpan(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxDateSpan[] = {
    {(void *)slot_wxDateSpan___ne__, ne_slot},
    {(void *)slot_wxDateSpan___eq__, eq_slot},
    {(void *)slot_wxDateSpan___mul__, mul_slot},
    {(void *)slot_wxDateSpan___imul__, imul_slot},
    {(void *)slot_wxDateSpan___neg__, neg_slot},
    {(void *)slot_wxDateSpan___sub__, sub_slot},
    {(void *)slot_wxDateSpan___isub__, isub_slot},
    {(void *)slot_wxDateSpan___add__, add_slot},
    {(void *)slot_wxDateSpan___iadd__, iadd_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxDateSpan[] = {
    {sipName_Add, SIP_MLMETH_CAST(meth_wxDateSpan_Add), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_Add},
    {sipName_Day, meth_wxDateSpan_Day, METH_VARARGS, doc_wxDateSpan_Day},
    {sipName_Days, SIP_MLMETH_CAST(meth_wxDateSpan_Days), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_Days},
    {sipName_GetDays, meth_wxDateSpan_GetDays, METH_VARARGS, doc_wxDateSpan_GetDays},
    {sipName_GetMonths, meth_wxDateSpan_GetMonths, METH_VARARGS, doc_wxDateSpan_GetMonths},
    {sipName_GetTotalDays, meth_wxDateSpan_GetTotalDays, METH_VARARGS, doc_wxDateSpan_GetTotalDays},
    {sipName_GetTotalMonths, meth_wxDateSpan_GetTotalMonths, METH_VARARGS, doc_wxDateSpan_GetTotalMonths},
    {sipName_GetWeeks, meth_wxDateSpan_GetWeeks, METH_VARARGS, doc_wxDateSpan_GetWeeks},
    {sipName_GetYears, meth_wxDateSpan_GetYears, METH_VARARGS, doc_wxDateSpan_GetYears},
    {sipName_Month, meth_wxDateSpan_Month, METH_VARARGS, doc_wxDateSpan_Month},
    {sipName_Months, SIP_MLMETH_CAST(meth_wxDateSpan_Months), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_Months},
    {sipName_Multiply, SIP_MLMETH_CAST(meth_wxDateSpan_Multiply), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_Multiply},
    {sipName_Neg, meth_wxDateSpan_Neg, METH_VARARGS, doc_wxDateSpan_Neg},
    {sipName_Negate, meth_wxDateSpan_Negate, METH_VARARGS, doc_wxDateSpan_Negate},
    {sipName_SetDays, SIP_MLMETH_CAST(meth_wxDateSpan_SetDays), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_SetDays},
    {sipName_SetMonths, SIP_MLMETH_CAST(meth_wxDateSpan_SetMonths), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_SetMonths},
    {sipName_SetWeeks, SIP_MLMETH_CAST(meth_wxDateSpan_SetWeeks), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_SetWeeks},
    {sipName_SetYears, SIP_MLMETH_CAST(meth_wxDateSpan_SetYears), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_SetYears},
    {sipName_Subtract, SIP_MLMETH_CAST(meth_wxDateSpan_Subtract), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_Subtract},
    {sipName_Week, meth_wxDateSpan_Week, METH_VARARGS, doc_wxDateSpan_Week},
    {sipName_Weeks, SIP_MLMETH_CAST(meth_wxDateSpan_Weeks), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_Weeks},
    {sipName_Year, meth_wxDateSpan_Year, METH_VARARGS, doc_wxDateSpan_Year},
    {sipName_Years, SIP_MLMETH_CAST(meth_wxDateSpan_Years), METH_VARARGS|METH_KEYWORDS, doc_wxDateSpan_Years}
};

PyDoc_STRVAR(doc_wxDateSpan, "DateSpan(years=0, months=0, weeks=0, days=0) -> None\n"
"\n"
"This class is a \"logical time span\" and is useful for implementing\n"
"program logic for such things as \"add one month to the date\" which, in\n"
"general, doesn't mean to add 60*60*24*31 seconds to it, but to take\n"
"the same date the next month (to understand that this is indeed\n"
"different consider adding one month to Feb, 15  we want to get Mar,\n"
"15, of course).");


sipClassTypeDef sipTypeDef__core_wxDateSpan = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxDateSpan,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_DateSpan,
        {0, 0, 1},
        23, methods_wxDateSpan,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxDateSpan,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxDateSpan,
    init_type_wxDateSpan,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxDateSpan,
    assign_wxDateSpan,
    array_wxDateSpan,
    copy_wxDateSpan,
    release_wxDateSpan,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxDateSpan,
    sizeof (::wxDateSpan),
};
