/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/colour.h>
    #include <wx/setup.h>
    #include <wxPython/wxpy_api.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    wxIntPtr* _wxColour_GetPixel(wxColour* self)
    {
        #if defined(__WXGTK3__) || defined(__WXOSX__)
            return new wxIntPtr(0);
        #else
            return new wxIntPtr((wxIntPtr)self->GetPixel());
        #endif
    }
    void _wxColour__copyFrom(wxColour* self, const wxColour* other)
    {
        *self = *other;
    }
    PyObject* _wxColour_Get(wxColour* self, bool includeAlpha)
    {
        int red = -1;
        int green = -1;
        int blue = -1;
        int alpha = wxALPHA_OPAQUE;
        if (self->IsOk()) {
            red =   self->Red();
            green = self->Green();
            blue =  self->Blue();
            alpha = self->Alpha();
        }
        wxPyThreadBlocker blocker;
        if (includeAlpha)
            return sipBuildResult(0, "(iiii)", red, green, blue, alpha);
        else
            return sipBuildResult(0, "(iii)", red, green, blue);
    }
    int _wxColour___nonzero__(wxColour* self)
    {
        return self->IsOk();
    }
    int _wxColour___bool__(wxColour* self)
    {
        return self->IsOk();
    }


PyDoc_STRVAR(doc_wxColour_SetRGB, "SetRGB(colRGB) -> None\n"
"\n"
"Sets the RGB or RGBA colour values from a single 32 bit value.");

extern "C" {static PyObject *meth_wxColour_SetRGB(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_SetRGB(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxUint32 colRGB;
        ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colRGB,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bu", &sipSelf, sipType_wxColour, &sipCpp, &colRGB))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRGB(colRGB);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_SetRGB, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_SetRGBA, "SetRGBA(colRGBA) -> None\n"
"\n"
"Sets the RGB or RGBA colour values from a single 32 bit value.");

extern "C" {static PyObject *meth_wxColour_SetRGBA(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_SetRGBA(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxUint32 colRGBA;
        ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colRGBA,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bu", &sipSelf, sipType_wxColour, &sipCpp, &colRGBA))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRGBA(colRGBA);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_SetRGBA, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_GetRGB, "GetRGB() -> Uint32\n"
"\n"
"Gets the RGB or RGBA colour values as a single 32 bit value.");

extern "C" {static PyObject *meth_wxColour_GetRGB(PyObject *, PyObject *);}
static PyObject *meth_wxColour_GetRGB(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            ::wxUint32 sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRGB();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_GetRGB, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_GetRGBA, "GetRGBA() -> Uint32\n"
"\n"
"Gets the RGB or RGBA colour values as a single 32 bit value.");

extern "C" {static PyObject *meth_wxColour_GetRGBA(PyObject *, PyObject *);}
static PyObject *meth_wxColour_GetRGBA(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            ::wxUint32 sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRGBA();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_GetRGBA, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_Set, "Set(red, green, blue, alpha=ALPHA_OPAQUE) -> None\n"
"Set(RGB) -> None\n"
"Set(str) -> bool\n"
"\n"
"Sets the RGB intensity values using the given values (first overload), extracting them from the packed long (second overload), using the given string (third overload).\n"
"\n"
"");

extern "C" {static PyObject *meth_wxColour_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned char red;
        unsigned char green;
        unsigned char blue;
        unsigned char alpha = wxALPHA_OPAQUE;
        ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_red,
            sipName_green,
            sipName_blue,
            sipName_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BMMM|M", &sipSelf, sipType_wxColour, &sipCpp, &red, &green, &blue, &alpha))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Set(red, green, blue, alpha);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        unsigned long RGB;
        ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_RGB,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bm", &sipSelf, sipType_wxColour, &sipCpp, &RGB))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Set(RGB);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxString* str;
        int strState = 0;
        ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxColour, &sipCpp, sipType_wxString, &str, &strState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Set(*str);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str), sipType_wxString, strState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_Set, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_Alpha, "Alpha() -> int\n"
"\n"
"Returns the alpha value, on platforms where alpha is not yet\n"
"supported, this always returns wxALPHA_OPAQUE.");

extern "C" {static PyObject *meth_wxColour_Alpha(PyObject *, PyObject *);}
static PyObject *meth_wxColour_Alpha(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Alpha();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_Alpha, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_Blue, "Blue() -> int\n"
"\n"
"Returns the blue intensity.");

extern "C" {static PyObject *meth_wxColour_Blue(PyObject *, PyObject *);}
static PyObject *meth_wxColour_Blue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Blue();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_Blue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_GetAlpha, "GetAlpha() -> int\n"
"\n"
"Returns the alpha value, on platforms where alpha is not yet\n"
"supported, this always returns wxALPHA_OPAQUE.");

extern "C" {static PyObject *meth_wxColour_GetAlpha(PyObject *, PyObject *);}
static PyObject *meth_wxColour_GetAlpha(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            uint sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAlpha();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_GetAlpha, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_GetBlue, "GetBlue() -> int\n"
"\n"
"Returns the blue intensity as unsigned int.");

extern "C" {static PyObject *meth_wxColour_GetBlue(PyObject *, PyObject *);}
static PyObject *meth_wxColour_GetBlue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            uint sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBlue();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_GetBlue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_GetGreen, "GetGreen() -> int\n"
"\n"
"Returns the green intensity as unsigned int.");

extern "C" {static PyObject *meth_wxColour_GetGreen(PyObject *, PyObject *);}
static PyObject *meth_wxColour_GetGreen(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            uint sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetGreen();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_GetGreen, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_GetRed, "GetRed() -> int\n"
"\n"
"Returns the red intensity as unsigned int.");

extern "C" {static PyObject *meth_wxColour_GetRed(PyObject *, PyObject *);}
static PyObject *meth_wxColour_GetRed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            uint sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRed();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_GetRed, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_GetAsString, "GetAsString(flags=C2S_NAME|C2S_CSS_SYNTAX) -> str\n"
"\n"
"Converts this colour to a wxString using the given flags.");

extern "C" {static PyObject *meth_wxColour_GetAsString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_GetAsString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long flags = wxC2S_NAME|wxC2S_CSS_SYNTAX;
        const ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|l", &sipSelf, sipType_wxColour, &sipCpp, &flags))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetAsString(flags));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_GetAsString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_GetLuminance, "GetLuminance() -> float\n"
"\n"
"Return the perceived brightness of the colour.");

extern "C" {static PyObject *meth_wxColour_GetLuminance(PyObject *, PyObject *);}
static PyObject *meth_wxColour_GetLuminance(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLuminance();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_GetLuminance, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_GetPixel, "GetPixel() -> IntPtr");

extern "C" {static PyObject *meth_wxColour_GetPixel(PyObject *, PyObject *);}
static PyObject *meth_wxColour_GetPixel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            ::wxIntPtr*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxColour_GetPixel(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes, sipType_wxIntPtr, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_GetPixel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_Green, "Green() -> int\n"
"\n"
"Returns the green intensity.");

extern "C" {static PyObject *meth_wxColour_Green(PyObject *, PyObject *);}
static PyObject *meth_wxColour_Green(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Green();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_Green, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the colour object is valid (the colour has been\n"
"initialised with RGB values).");

extern "C" {static PyObject *meth_wxColour_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxColour_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_Red, "Red() -> int\n"
"\n"
"Returns the red intensity.");

extern "C" {static PyObject *meth_wxColour_Red(PyObject *, PyObject *);}
static PyObject *meth_wxColour_Red(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Red();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_Red, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_IsSolid, "IsSolid() -> bool\n"
"\n"
"Returns true if the color can be described using RGB values, i.e.");

extern "C" {static PyObject *meth_wxColour_IsSolid(PyObject *, PyObject *);}
static PyObject *meth_wxColour_IsSolid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSolid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_IsSolid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_MakeDisabled, "MakeDisabled(brightness=255) -> Colour\n"
"MakeDisabled(r, g, b, brightness=255) -> Tuple[int, int, int]\n"
"\n"
"Make a disabled version of this colour.\n"
"");

extern "C" {static PyObject *meth_wxColour_MakeDisabled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_MakeDisabled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned char brightness = 255;
        ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brightness,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|M", &sipSelf, sipType_wxColour, &sipCpp, &brightness))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeDisabled(brightness);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    {
        unsigned char r;
        unsigned char g;
        unsigned char b;
        unsigned char brightness = 255;

        static const char *sipKwdList[] = {
            sipName_r,
            sipName_g,
            sipName_b,
            sipName_brightness,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "ccc|M", &r, &g, &b, &brightness))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxColour::MakeDisabled(&r, &g, &b, brightness);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(ccc)", r, g, b);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_MakeDisabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_ChangeLightness, "ChangeLightness(ialpha) -> Colour\n"
"ChangeLightness(r, g, b, ialpha) -> Tuple[int, int, int]\n"
"\n"
"wxColour wrapper for ChangeLightness(r,g,b,ialpha).\n"
"");

extern "C" {static PyObject *meth_wxColour_ChangeLightness(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_ChangeLightness(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int ialpha;
        const ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ialpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxColour, &sipCpp, &ialpha))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->ChangeLightness(ialpha));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    {
        unsigned char r;
        unsigned char g;
        unsigned char b;
        int ialpha;

        static const char *sipKwdList[] = {
            sipName_r,
            sipName_g,
            sipName_b,
            sipName_ialpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "ccci", &r, &g, &b, &ialpha))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxColour::ChangeLightness(&r, &g, &b, ialpha);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(ccc)", r, g, b);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_ChangeLightness, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_MakeMono, "MakeMono(on) -> Tuple[int, int, int]\n"
"\n"
"Assigns the same value to r, g, b: 0 if on is false, 255 otherwise.");

extern "C" {static PyObject *meth_wxColour_MakeMono(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_MakeMono(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned char r;
        unsigned char g;
        unsigned char b;
        bool on;

        static const char *sipKwdList[] = {
            sipName_on,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "b", &on))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxColour::MakeMono(&r, &g, &b, on);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(ccc)", r, g, b);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_MakeMono, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_MakeGrey, "MakeGrey(r, g, b) -> Tuple[int, int, int]\n"
"MakeGrey(r, g, b, weight_r, weight_g, weight_b) -> Tuple[int, int, int]\n"
"\n"
"Create a grey colour from (in/out) rgb parameters using integer\n"
"arithmetic.\n"
"");

extern "C" {static PyObject *meth_wxColour_MakeGrey(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_MakeGrey(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned char r;
        unsigned char g;
        unsigned char b;

        static const char *sipKwdList[] = {
            sipName_r,
            sipName_g,
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "ccc", &r, &g, &b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxColour::MakeGrey(&r, &g, &b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(ccc)", r, g, b);
        }
    }

    {
        unsigned char r;
        unsigned char g;
        unsigned char b;
        double weight_r;
        double weight_g;
        double weight_b;

        static const char *sipKwdList[] = {
            sipName_r,
            sipName_g,
            sipName_b,
            sipName_weight_r,
            sipName_weight_g,
            sipName_weight_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "cccddd", &r, &g, &b, &weight_r, &weight_g, &weight_b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxColour::MakeGrey(&r, &g, &b, weight_r, weight_g, weight_b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(ccc)", r, g, b);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_MakeGrey, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_AlphaBlend, "AlphaBlend(fg, bg, alpha) -> int\n"
"\n"
"Blend colour, taking alpha into account.");

extern "C" {static PyObject *meth_wxColour_AlphaBlend(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_AlphaBlend(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned char fg;
        unsigned char bg;
        double alpha;

        static const char *sipKwdList[] = {
            sipName_fg,
            sipName_bg,
            sipName_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "MMd", &fg, &bg, &alpha))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxColour::AlphaBlend(fg, bg, alpha);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_AlphaBlend, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour__copyFrom, "_copyFrom(other) -> None\n"
"\n"
"For internal use only.");

extern "C" {static PyObject *meth_wxColour__copyFrom(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour__copyFrom(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* other;
        int otherState = 0;
        ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0", &sipSelf, sipType_wxColour, &sipCpp, sipType_wxColour, &other, &otherState))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxColour__copyFrom(sipCpp, other);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxColour *>(other), sipType_wxColour, otherState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName__copyFrom, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour_Get, "Get(includeAlpha=True) -> (r,g,b) or (r,g,b,a)\n"
"\n"
"Returns the RGB intensity values as a tuple, optionally the alpha\n"
"value as well.");

extern "C" {static PyObject *meth_wxColour_Get(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColour_Get(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool includeAlpha = 1;
        ::wxColour *sipCpp;

        static const char *sipKwdList[] = {
            sipName_includeAlpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxColour, &sipCpp, &includeAlpha))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxColour_Get(sipCpp, includeAlpha);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName_Get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColour___nonzero__, "__nonzero__() -> bool");

extern "C" {static PyObject *meth_wxColour___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxColour___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxColour *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColour, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxColour___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Colour, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxColour___bool__(PyObject *);}
static int slot_wxColour___bool__(PyObject *sipSelf)
{
    ::wxColour *sipCpp = reinterpret_cast< ::wxColour *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxColour));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxColour___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxColour___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxColour___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxColour *sipCpp = reinterpret_cast< ::wxColour *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxColour));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxColour, &colour, &colourState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxColour::operator==(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxColour, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxColour___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxColour___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxColour *sipCpp = reinterpret_cast< ::wxColour *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxColour));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxColour, &colour, &colourState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxColour::operator!=(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxColour, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxColour(void *, const sipTypeDef *);}
static void *cast_wxColour(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxColour *sipCpp = reinterpret_cast< ::wxColour *>(sipCppV);

    if (targetType == sipType_wxColour)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxColour(void *, int);}
static void release_wxColour(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxColour *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxColour(Py_ssize_t);}
static void *array_wxColour(Py_ssize_t sipNrElem)
{
    return new ::wxColour[sipNrElem];
}


extern "C" {static void array_delete_wxColour(void *);}
static void array_delete_wxColour(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxColour *>(sipCpp);
}


extern "C" {static void assign_wxColour(void *, Py_ssize_t, void *);}
static void assign_wxColour(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxColour *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxColour *>(sipSrc);
}


extern "C" {static void *copy_wxColour(const void *, Py_ssize_t);}
static void *copy_wxColour(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxColour(reinterpret_cast<const ::wxColour *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxColour(sipSimpleWrapper *);}
static void dealloc_wxColour(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxColour(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxColour(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxColour(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxColour *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        unsigned char red;
        unsigned char green;
        unsigned char blue;
        unsigned char alpha = wxALPHA_OPAQUE;

        static const char *sipKwdList[] = {
            sipName_red,
            sipName_green,
            sipName_blue,
            sipName_alpha,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "MMM|M", &red, &green, &blue, &alpha))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxColour(red, green, blue, alpha);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        unsigned long colRGB;

        static const char *sipKwdList[] = {
            sipName_colRGB,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "m", &colRGB))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxColour(colRGB);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxColour* colour;
        int colourState = 0;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxColour, &colour, &colourState))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_wxColour(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxColour(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::wxColour **sipCppPtr = reinterpret_cast< ::wxColour **>(sipCppPtrV);
        // is it just a typecheck?
        if (!sipIsErr) {
            if (sipPy == Py_None)
                return 1;
            if (sipCanConvertToType(sipPy, sipType_wxColour, SIP_NO_CONVERTORS))
                return 1;
            if (PyBytes_Check(sipPy) || PyUnicode_Check(sipPy))
                return 1;
            if (wxPyNumberSequenceCheck(sipPy, 4) || wxPyNumberSequenceCheck(sipPy, 3)) {
                return 1;
            }
            return 0;
        }
        
        // otherwise do the conversion
        // is it None?
        if (sipPy == Py_None) {
            *sipCppPtr = new wxColour(wxNullColour);
            return sipGetState(sipTransferObj);
        }
        // Is it a string?
        else if (PyBytes_Check(sipPy) || PyUnicode_Check(sipPy)) {
            wxString spec = Py2wxString(sipPy);
            if (!spec.empty()
                && spec.GetChar(0) == '#'
                && (spec.length() == 7 || spec.length() == 9)) {  // It's  #RRGGBB[AA]
                long red, green, blue;
                red = green = blue = 0;
                spec.Mid(1,2).ToLong(&red,   16);
                spec.Mid(3,2).ToLong(&green, 16);
                spec.Mid(5,2).ToLong(&blue,  16);
        
                if (spec.length() == 7)         // no alpha
                    *sipCppPtr = new wxColour(red, green, blue);
                else {                          // yes alpha
                    long alpha;
                    spec.Mid(7,2).ToLong(&alpha, 16);
                    *sipCppPtr = new wxColour(red, green, blue, alpha);
                }
                return sipGetState(sipTransferObj);
            }
            else {                                       // assume it's a colour name
                // check if alpha is there too
                int pos;
                if (((pos = spec.Find(':', true)) != wxNOT_FOUND) && (pos == spec.length()-3)) {
                    long alpha;
                    spec.Right(2).ToLong(&alpha, 16);
                    wxColour c = wxColour(spec.Left(spec.length()-3));
                    *sipCppPtr = new wxColour(c.Red(), c.Green(), c.Blue(), alpha);
                }
                else
                    *sipCppPtr = new wxColour(spec);
                return sipGetState(sipTransferObj);
            }
        }
        // Is it a sequence? (if so then length was checked above)
        else if (wxPyNumberSequenceCheck(sipPy)) {
            size_t len = PySequence_Size(sipPy);
        
            PyObject* o1 = PySequence_ITEM(sipPy, 0);
            PyObject* o2 = PySequence_ITEM(sipPy, 1);
            PyObject* o3 = PySequence_ITEM(sipPy, 2);
            if (len == 3)
                *sipCppPtr = new wxColour(wxPyInt_AsLong(o1), wxPyInt_AsLong(o2), wxPyInt_AsLong(o3));
            else {
                PyObject* o4 = PySequence_ITEM(sipPy, 3);
                *sipCppPtr = new wxColour(wxPyInt_AsLong(o1), wxPyInt_AsLong(o2), wxPyInt_AsLong(o3),
                                          wxPyInt_AsLong(o4));
                Py_DECREF(o4);
            }
            Py_DECREF(o1);
            Py_DECREF(o2);
            Py_DECREF(o3);
            return sipGetState(sipTransferObj);
        }
        
        // if we get this far then it must already be a wxColour instance
        *sipCppPtr = reinterpret_cast<wxColour*>(sipConvertToType(
            sipPy, sipType_wxColour, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));
        return 0; // not a new instance
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxColour[] = {{392, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxColour[] = {
    {(void *)slot_wxColour___bool__, bool_slot},
    {(void *)slot_wxColour___eq__, eq_slot},
    {(void *)slot_wxColour___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxColour[] = {
    {sipName_Alpha, meth_wxColour_Alpha, METH_VARARGS, doc_wxColour_Alpha},
    {sipName_AlphaBlend, SIP_MLMETH_CAST(meth_wxColour_AlphaBlend), METH_VARARGS|METH_KEYWORDS, doc_wxColour_AlphaBlend},
    {sipName_Blue, meth_wxColour_Blue, METH_VARARGS, doc_wxColour_Blue},
    {sipName_ChangeLightness, SIP_MLMETH_CAST(meth_wxColour_ChangeLightness), METH_VARARGS|METH_KEYWORDS, doc_wxColour_ChangeLightness},
    {sipName_Get, SIP_MLMETH_CAST(meth_wxColour_Get), METH_VARARGS|METH_KEYWORDS, doc_wxColour_Get},
    {sipName_GetAlpha, meth_wxColour_GetAlpha, METH_VARARGS, doc_wxColour_GetAlpha},
    {sipName_GetAsString, SIP_MLMETH_CAST(meth_wxColour_GetAsString), METH_VARARGS|METH_KEYWORDS, doc_wxColour_GetAsString},
    {sipName_GetBlue, meth_wxColour_GetBlue, METH_VARARGS, doc_wxColour_GetBlue},
    {sipName_GetGreen, meth_wxColour_GetGreen, METH_VARARGS, doc_wxColour_GetGreen},
    {sipName_GetLuminance, meth_wxColour_GetLuminance, METH_VARARGS, doc_wxColour_GetLuminance},
    {sipName_GetPixel, meth_wxColour_GetPixel, METH_VARARGS, doc_wxColour_GetPixel},
    {sipName_GetRGB, meth_wxColour_GetRGB, METH_VARARGS, doc_wxColour_GetRGB},
    {sipName_GetRGBA, meth_wxColour_GetRGBA, METH_VARARGS, doc_wxColour_GetRGBA},
    {sipName_GetRed, meth_wxColour_GetRed, METH_VARARGS, doc_wxColour_GetRed},
    {sipName_Green, meth_wxColour_Green, METH_VARARGS, doc_wxColour_Green},
    {sipName_IsOk, meth_wxColour_IsOk, METH_VARARGS, doc_wxColour_IsOk},
    {sipName_IsSolid, meth_wxColour_IsSolid, METH_VARARGS, doc_wxColour_IsSolid},
    {sipName_MakeDisabled, SIP_MLMETH_CAST(meth_wxColour_MakeDisabled), METH_VARARGS|METH_KEYWORDS, doc_wxColour_MakeDisabled},
    {sipName_MakeGrey, SIP_MLMETH_CAST(meth_wxColour_MakeGrey), METH_VARARGS|METH_KEYWORDS, doc_wxColour_MakeGrey},
    {sipName_MakeMono, SIP_MLMETH_CAST(meth_wxColour_MakeMono), METH_VARARGS|METH_KEYWORDS, doc_wxColour_MakeMono},
    {sipName_Red, meth_wxColour_Red, METH_VARARGS, doc_wxColour_Red},
    {sipName_Set, SIP_MLMETH_CAST(meth_wxColour_Set), METH_VARARGS|METH_KEYWORDS, doc_wxColour_Set},
    {sipName_SetRGB, SIP_MLMETH_CAST(meth_wxColour_SetRGB), METH_VARARGS|METH_KEYWORDS, doc_wxColour_SetRGB},
    {sipName_SetRGBA, SIP_MLMETH_CAST(meth_wxColour_SetRGBA), METH_VARARGS|METH_KEYWORDS, doc_wxColour_SetRGBA},
    {sipName___nonzero__, meth_wxColour___nonzero__, METH_VARARGS, doc_wxColour___nonzero__},
    {sipName__copyFrom, SIP_MLMETH_CAST(meth_wxColour__copyFrom), METH_VARARGS|METH_KEYWORDS, doc_wxColour__copyFrom}
};

sipVariableDef variables_wxColour[] = {
    {PropertyVariable, sipName_alpha, &methods_wxColour[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_blue, &methods_wxColour[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_green, &methods_wxColour[14], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_red, &methods_wxColour[20], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RGBA, &methods_wxColour[12], &methods_wxColour[23], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RGB, &methods_wxColour[11], &methods_wxColour[22], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Pixel, &methods_wxColour[10], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxColour, "Colour() -> None\n"
"Colour(red, green, blue, alpha=ALPHA_OPAQUE) -> None\n"
"Colour(colRGB) -> None\n"
"Colour(colour) -> None\n"
"\n"
"A colour is an object representing a combination of Red, Green, and\n"
"Blue (RGB) intensity values and an Alpha value, and is used to\n"
"determine drawing colours.");


sipClassTypeDef sipTypeDef__core_wxColour = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_ALLOW_NONE|SIP_TYPE_CLASS,
        sipNameNr_wxColour,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_Colour,
        {0, 0, 1},
        26, methods_wxColour,
        0, SIP_NULLPTR,
        7, variables_wxColour,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxColour,
    -1,
    -1,
    supers_wxColour,
    slots_wxColour,
    init_type_wxColour,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxColour,
    assign_wxColour,
    array_wxColour,
    copy_wxColour,
    release_wxColour,
    cast_wxColour,
    convertTo_wxColour,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxColour,
    sizeof (::wxColour),
};
