/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_dataview.h"
        #include <wx/dataview.h>


PyDoc_STRVAR(doc_wxDataViewItemArray_append, "append(self, obj: DataViewItem)");

extern "C" {static PyObject *meth_wxDataViewItemArray_append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemArray_append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDataViewItem* obj;
        ::wxDataViewItemArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewItemArray, &sipCpp, sipType_wxDataViewItem, &obj))
        {
        sipCpp->Add(*obj);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemArray, sipName_append, doc_wxDataViewItemArray_append);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemArray_index, "index(self, obj: DataViewItem) -> int");

extern "C" {static PyObject *meth_wxDataViewItemArray_index(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemArray_index(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDataViewItem* obj;
        ::wxDataViewItemArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewItemArray, &sipCpp, sipType_wxDataViewItem, &obj))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;
        int idx = sipCpp->Index(*obj, false);
        if (idx == wxNOT_FOUND) {
            sipError = sipErrorFail;
            wxPyErr_SetString(PyExc_ValueError,
                              "sequence.index(x): x not in sequence");
            }
        sipRes = idx;

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemArray, sipName_index, doc_wxDataViewItemArray_index);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxDataViewItemArray___contains__(PyObject *, PyObject *);}
static int slot_wxDataViewItemArray___contains__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxDataViewItemArray *sipCpp = reinterpret_cast< ::wxDataViewItemArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDataViewItemArray));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDataViewItem* obj;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxDataViewItem, &obj))
        {
            int sipRes = 0;
        int idx = sipCpp->Index(*obj, false);
        sipRes = idx != wxNOT_FOUND;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemArray, sipName___contains__, SIP_NULLPTR);

    return -1;
}


extern "C" {static PyObject *slot_wxDataViewItemArray___getitem__(PyObject *, PyObject *);}
static PyObject *slot_wxDataViewItemArray___getitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxDataViewItemArray *sipCpp = reinterpret_cast< ::wxDataViewItemArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDataViewItemArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long index;

        if (sipParseArgs(&sipParseErr, sipArg, "1l", &index))
        {
            ::wxDataViewItem*sipRes = 0;
            sipErrorState sipError = sipErrorNone;
            if (0 > index)
                index += sipCpp->GetCount();

            if ((index < sipCpp->GetCount()) && (0 <= index)) {
                sipRes = &sipCpp->Item(index);
            }
            else {
                wxPyErr_SetString(PyExc_IndexError, "sequence index out of range");
                sipError = sipErrorFail;
            }

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipConvertFromType(sipRes, sipType_wxDataViewItem, SIP_NULLPTR);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemArray, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static Py_ssize_t slot_wxDataViewItemArray___len__(PyObject *);}
static Py_ssize_t slot_wxDataViewItemArray___len__(PyObject *sipSelf)
{
    ::wxDataViewItemArray *sipCpp = reinterpret_cast< ::wxDataViewItemArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDataViewItemArray));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;
        sipRes = sipCpp->GetCount();

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDataViewItemArray(void *, int);}
static void release_wxDataViewItemArray(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDataViewItemArray *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxDataViewItemArray(Py_ssize_t);}
static void *array_wxDataViewItemArray(Py_ssize_t sipNrElem)
{
    return new ::wxDataViewItemArray[sipNrElem];
}


extern "C" {static void array_delete_wxDataViewItemArray(void *);}
static void array_delete_wxDataViewItemArray(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxDataViewItemArray *>(sipCpp);
}


extern "C" {static void assign_wxDataViewItemArray(void *, Py_ssize_t, void *);}
static void assign_wxDataViewItemArray(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxDataViewItemArray *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxDataViewItemArray *>(sipSrc);
}


extern "C" {static void *copy_wxDataViewItemArray(const void *, Py_ssize_t);}
static void *copy_wxDataViewItemArray(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxDataViewItemArray(reinterpret_cast<const ::wxDataViewItemArray *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxDataViewItemArray(sipSimpleWrapper *);}
static void dealloc_wxDataViewItemArray(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDataViewItemArray(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxDataViewItemArray(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDataViewItemArray(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxDataViewItemArray *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxDataViewItemArray();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::wxDataViewItemArray* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxDataViewItemArray, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxDataViewItemArray(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxDataViewItemArray[] = {
    {(void *)slot_wxDataViewItemArray___contains__, contains_slot},
    {(void *)slot_wxDataViewItemArray___getitem__, getitem_slot},
    {(void *)slot_wxDataViewItemArray___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxDataViewItemArray[] = {
    {sipName_append, SIP_MLMETH_CAST(meth_wxDataViewItemArray_append), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewItemArray_append},
    {sipName_index, SIP_MLMETH_CAST(meth_wxDataViewItemArray_index), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewItemArray_index}
};

PyDoc_STRVAR(doc_wxDataViewItemArray, "\1DataViewItemArray()\n"
"DataViewItemArray(a0: DataViewItemArray)");


sipClassTypeDef sipTypeDef__dataview_wxDataViewItemArray = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxDataViewItemArray,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_DataViewItemArray,
        {0, 0, 1},
        2, methods_wxDataViewItemArray,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxDataViewItemArray,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxDataViewItemArray,
    init_type_wxDataViewItemArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxDataViewItemArray,
    assign_wxDataViewItemArray,
    array_wxDataViewItemArray,
    copy_wxDataViewItemArray,
    release_wxDataViewItemArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxDataViewItemArray,
    sizeof (::wxDataViewItemArray),
};
