/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/brush.h>
        #include <wx/colour.h>
        #include <wx/bitmap.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #ifdef __WXMAC__
        #include <wx/osx/private.h>
        #endif
    int _wxBrush___nonzero__(wxBrush* self)
    {
        return self->IsOk();
    }
    int _wxBrush___bool__(wxBrush* self)
    {
        return self->IsOk();
    }
    void _wxBrush_MacSetTheme(wxBrush* self, int macThemeBrushID)
    {
        #ifdef __WXMAC__
            self->SetColour(wxColour(wxMacCreateCGColorFromHITheme(macThemeBrushID)));
        #else
            wxPyRaiseNotImplemented();
        #endif
    }
    void _wxBrush__copyFrom(wxBrush* self, const wxBrush* other)
    {
        *self = *other;
    }


PyDoc_STRVAR(doc_wxBrush_SetColour, "SetColour(colour) -> None\n"
"SetColour(red, green, blue) -> None\n"
"\n"
"Sets the brush colour using red, green and blue values.\n"
"");

extern "C" {static PyObject *meth_wxBrush_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxBrush, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        unsigned char red;
        unsigned char green;
        unsigned char blue;
        ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_red,
            sipName_green,
            sipName_blue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bccc", &sipSelf, sipType_wxBrush, &sipCpp, &red, &green, &blue))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(red, green, blue);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_SetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_GetColour, "GetColour() -> Colour\n"
"\n"
"Returns a reference to the brush colour.");

extern "C" {static PyObject *meth_wxBrush_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_GetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_GetStipple, "GetStipple() -> Bitmap\n"
"\n"
"Gets a pointer to the stipple bitmap.");

extern "C" {static PyObject *meth_wxBrush_GetStipple(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_GetStipple(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStipple();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_GetStipple, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_GetStyle, "GetStyle() -> BrushStyle\n"
"\n"
"Returns the brush style, one of the wxBrushStyle values.");

extern "C" {static PyObject *meth_wxBrush_GetStyle(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_GetStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            ::wxBrushStyle sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxBrushStyle);
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_GetStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_IsHatch, "IsHatch() -> bool\n"
"\n"
"Returns true if the style of the brush is any of hatched fills.");

extern "C" {static PyObject *meth_wxBrush_IsHatch(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_IsHatch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsHatch();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_IsHatch, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the brush is initialised.");

extern "C" {static PyObject *meth_wxBrush_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_IsNonTransparent, "IsNonTransparent() -> bool\n"
"\n"
"Returns true if the brush is a valid non-transparent brush.");

extern "C" {static PyObject *meth_wxBrush_IsNonTransparent(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_IsNonTransparent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsNonTransparent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_IsNonTransparent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_IsTransparent, "IsTransparent() -> bool\n"
"\n"
"Returns true if the brush is transparent.");

extern "C" {static PyObject *meth_wxBrush_IsTransparent(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_IsTransparent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsTransparent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_IsTransparent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_SetStipple, "SetStipple(bitmap) -> None\n"
"\n"
"Sets the stipple bitmap.");

extern "C" {static PyObject *meth_wxBrush_SetStipple(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush_SetStipple(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBitmap* bitmap;
        ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxBrush, &sipCpp, sipType_wxBitmap, &bitmap))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStipple(*bitmap);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_SetStipple, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_SetStyle, "SetStyle(style) -> None\n"
"\n"
"Sets the brush style.");

extern "C" {static PyObject *meth_wxBrush_SetStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush_SetStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxBrushStyle style;
        ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxBrush, &sipCpp, sipType_wxBrushStyle, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStyle(style);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_SetStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush___nonzero__, "__nonzero__() -> bool");

extern "C" {static PyObject *meth_wxBrush___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxBrush___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBrush___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush_MacSetTheme, "MacSetTheme(macThemeBrushID) -> None");

extern "C" {static PyObject *meth_wxBrush_MacSetTheme(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush_MacSetTheme(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int macThemeBrushID;
        ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_macThemeBrushID,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxBrush, &sipCpp, &macThemeBrushID))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxBrush_MacSetTheme(sipCpp, macThemeBrushID);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName_MacSetTheme, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBrush__copyFrom, "_copyFrom(other) -> None\n"
"\n"
"For internal use only.");

extern "C" {static PyObject *meth_wxBrush__copyFrom(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush__copyFrom(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush* other;
        ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxBrush, &sipCpp, sipType_wxBrush, &other))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxBrush__copyFrom(sipCpp, other);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Brush, sipName__copyFrom, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxBrush___bool__(PyObject *);}
static int slot_wxBrush___bool__(PyObject *sipSelf)
{
    ::wxBrush *sipCpp = reinterpret_cast< ::wxBrush *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxBrush));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBrush___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxBrush___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxBrush___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxBrush *sipCpp = reinterpret_cast< ::wxBrush *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxBrush));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush* brush;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxBrush, &brush))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxBrush::operator==(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxBrush, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxBrush___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxBrush___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxBrush *sipCpp = reinterpret_cast< ::wxBrush *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxBrush));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush* brush;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxBrush, &brush))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxBrush::operator!=(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxBrush, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxBrush(void *, const sipTypeDef *);}
static void *cast_wxBrush(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxBrush *sipCpp = reinterpret_cast< ::wxBrush *>(sipCppV);

    if (targetType == sipType_wxBrush)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxGDIObject)->ctd_cast(static_cast< ::wxGDIObject *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxBrush(void *, int);}
static void release_wxBrush(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxBrush *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxBrush(Py_ssize_t);}
static void *array_wxBrush(Py_ssize_t sipNrElem)
{
    return new ::wxBrush[sipNrElem];
}


extern "C" {static void array_delete_wxBrush(void *);}
static void array_delete_wxBrush(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxBrush *>(sipCpp);
}


extern "C" {static void assign_wxBrush(void *, Py_ssize_t, void *);}
static void assign_wxBrush(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxBrush *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxBrush *>(sipSrc);
}


extern "C" {static void *copy_wxBrush(const void *, Py_ssize_t);}
static void *copy_wxBrush(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxBrush(reinterpret_cast<const ::wxBrush *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxBrush(sipSimpleWrapper *);}
static void dealloc_wxBrush(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxBrush(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxBrush(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxBrush(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxBrush *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxBrush();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxBrushStyle style = wxBRUSHSTYLE_SOLID;

        static const char *sipKwdList[] = {
            sipName_colour,
            sipName_style,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|E", sipType_wxColour, &colour, &colourState, sipType_wxBrushStyle, &style))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxBrush(*colour, style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxBitmap* stippleBitmap;

        static const char *sipKwdList[] = {
            sipName_stippleBitmap,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBitmap, &stippleBitmap))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxBrush(*stippleBitmap);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxBrush* brush;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBrush, &brush))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxBrush(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxBrush[] = {{226, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxBrush[] = {
    {(void *)slot_wxBrush___bool__, bool_slot},
    {(void *)slot_wxBrush___eq__, eq_slot},
    {(void *)slot_wxBrush___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxBrush[] = {
    {sipName_GetColour, meth_wxBrush_GetColour, METH_VARARGS, doc_wxBrush_GetColour},
    {sipName_GetStipple, meth_wxBrush_GetStipple, METH_VARARGS, doc_wxBrush_GetStipple},
    {sipName_GetStyle, meth_wxBrush_GetStyle, METH_VARARGS, doc_wxBrush_GetStyle},
    {sipName_IsHatch, meth_wxBrush_IsHatch, METH_VARARGS, doc_wxBrush_IsHatch},
    {sipName_IsNonTransparent, meth_wxBrush_IsNonTransparent, METH_VARARGS, doc_wxBrush_IsNonTransparent},
    {sipName_IsOk, meth_wxBrush_IsOk, METH_VARARGS, doc_wxBrush_IsOk},
    {sipName_IsTransparent, meth_wxBrush_IsTransparent, METH_VARARGS, doc_wxBrush_IsTransparent},
    {sipName_MacSetTheme, SIP_MLMETH_CAST(meth_wxBrush_MacSetTheme), METH_VARARGS|METH_KEYWORDS, doc_wxBrush_MacSetTheme},
    {sipName_SetColour, SIP_MLMETH_CAST(meth_wxBrush_SetColour), METH_VARARGS|METH_KEYWORDS, doc_wxBrush_SetColour},
    {sipName_SetStipple, SIP_MLMETH_CAST(meth_wxBrush_SetStipple), METH_VARARGS|METH_KEYWORDS, doc_wxBrush_SetStipple},
    {sipName_SetStyle, SIP_MLMETH_CAST(meth_wxBrush_SetStyle), METH_VARARGS|METH_KEYWORDS, doc_wxBrush_SetStyle},
    {sipName___nonzero__, meth_wxBrush___nonzero__, METH_VARARGS, doc_wxBrush___nonzero__},
    {sipName__copyFrom, SIP_MLMETH_CAST(meth_wxBrush__copyFrom), METH_VARARGS|METH_KEYWORDS, doc_wxBrush__copyFrom}
};

sipVariableDef variables_wxBrush[] = {
    {PropertyVariable, sipName_Style, &methods_wxBrush[2], &methods_wxBrush[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Stipple, &methods_wxBrush[1], &methods_wxBrush[9], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Colour, &methods_wxBrush[0], &methods_wxBrush[8], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxBrush, "Brush() -> None\n"
"Brush(colour, style=BRUSHSTYLE_SOLID) -> None\n"
"Brush(stippleBitmap) -> None\n"
"Brush(brush) -> None\n"
"\n"
"A brush is a drawing tool for filling in areas.");


sipClassTypeDef sipTypeDef__core_wxBrush = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxBrush,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_Brush,
        {0, 0, 1},
        13, methods_wxBrush,
        0, SIP_NULLPTR,
        3, variables_wxBrush,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxBrush,
    -1,
    -1,
    supers_wxBrush,
    slots_wxBrush,
    init_type_wxBrush,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxBrush,
    assign_wxBrush,
    array_wxBrush,
    copy_wxBrush,
    release_wxBrush,
    cast_wxBrush,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxBrush,
    sizeof (::wxBrush),
};
